/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.esl.accesspoint.serial.FrameException;
import at.mrdevelopment.toolkit.checksum.CRC16;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UartLowlevelFrame {
    static ESLLogger logger = ESLLogger.getLogger(UartLowlevelFrame.class);
    protected static final int CRC_BYTES = 2;
    protected final ByteArrayInputStream stream;
    protected final byte[] frameData;

    public static UartLowlevelFrame loadFrame(InputStream inputStream, byte[] buffer) throws IOException, FrameException {
        int length = 0;
        while (length <= 0) {
            length = inputStream.read();
        }
        int dataLength = length - 2;
        int totalLength = length + 1;
        int bytesAvailable = inputStream.available();
        if (bytesAvailable > 74 && logger.isDebugEnabled()) {
            logger.debug("Missed slot request (%d waiting bytes from transmitter)", new Object[]{bytesAvailable});
        }
        if (dataLength <= 1) {
            throw new FrameException("Invalid frame size");
        }
        int header = inputStream.read();
        if ((header & 0xF0) != 160) {
            throw new FrameException("Invalid frame header");
        }
        buffer[0] = (byte)length;
        buffer[1] = (byte)header;
        int totalBytesRead = 2;
        while (totalBytesRead < totalLength) {
            int bytesRead = inputStream.read(buffer, totalBytesRead, totalLength - totalBytesRead);
            if (bytesRead <= 0) continue;
            totalBytesRead += bytesRead;
        }
        CRC16 crc16 = new CRC16();
        for (int index = 0; index < totalLength; ++index) {
            crc16.calc((int)buffer[index]);
        }
        int checksum = crc16.getChecksum();
        if (checksum != 0) {
            throw new FrameException("Checksum error");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Recv: length = %03d, header = %02X, checksum = %04X", new Object[]{length, header, checksum});
        }
        return new UartLowlevelFrame(new ByteArrayInputStream(buffer, 1, dataLength));
    }

    protected UartLowlevelFrame(ByteArrayInputStream stream) {
        this.stream = stream;
        this.frameData = null;
    }

    protected UartLowlevelFrame(byte[] frameData) {
        this.stream = null;
        this.frameData = frameData;
    }

    public byte[] getFrameData() {
        return this.frameData;
    }

    public ByteArrayInputStream getStream() {
        return this.stream;
    }

    protected static String getDataString(byte[] data) {
        StringBuilder dataString = new StringBuilder();
        dataString.append("{ ");
        for (byte dataByte : data) {
            dataString.append(String.format("0x%02X ", dataByte));
        }
        dataString.append("}");
        return dataString.toString();
    }
}

