/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.esl.accesspoint.serial.FrameInputStream;
import at.mrdevelopment.esl.accesspoint.serial.UartDataType;
import at.mrdevelopment.esl.accesspoint.serial.UartFrame;
import at.mrdevelopment.toolkit.nio.ExtendedByteBuffer;

public class UartExtendedDataInitRequest
implements UartFrame {
    public static final int COMMAND_ID = 166;
    private final UartDataType type;
    private final int svnVersion;

    public static UartExtendedDataInitRequest parse(FrameInputStream stream) throws Exception {
        UartDataType type = UartDataType.fromTypeId(stream.readByte());
        int length = stream.readByte();
        if (length >= 2) {
            int svnVersion = stream.readWord();
            UartExtendedDataInitRequest.flushStream(length - 2, stream);
            return new UartExtendedDataInitRequest(type, svnVersion);
        }
        UartExtendedDataInitRequest.flushStream(length, stream);
        return new UartExtendedDataInitRequest(type, 0);
    }

    public static UartExtendedDataInitRequest parse(byte[] frameData) throws Exception {
        ExtendedByteBuffer frameBuffer = ExtendedByteBuffer.createFrom((byte[])frameData);
        frameBuffer.internal().position(2);
        UartDataType type = UartDataType.fromTypeId(frameBuffer.getUnsignedByte());
        int length = frameBuffer.getUnsignedByte();
        if (length >= 2) {
            int svnVersion = frameBuffer.getUnsignedShort();
            return new UartExtendedDataInitRequest(type, svnVersion);
        }
        return new UartExtendedDataInitRequest(type, 0);
    }

    private static void flushStream(int length, FrameInputStream stream) throws Exception {
        while (length > 0) {
            stream.readByte();
            --length;
        }
    }

    private UartExtendedDataInitRequest(UartDataType type, int svnVersion) {
        this.type = type;
        this.svnVersion = svnVersion;
    }

    public UartDataType getType() {
        return this.type;
    }

    public int getSvnVersion() {
        return this.svnVersion;
    }
}

