/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.esl.accesspoint.serial.FrameInputStream;
import at.mrdevelopment.esl.accesspoint.serial.UartDataType;
import at.mrdevelopment.esl.accesspoint.serial.UartFrame;
import at.mrdevelopment.toolkit.nio.ExtendedByteBuffer;

public class UartDataRequest
implements UartFrame {
    public static final int COMMAND_ID = 162;
    private final UartDataType type;
    private final int offset;
    private final int length;

    public static UartDataRequest parse(FrameInputStream stream) throws Exception {
        UartDataType type = UartDataType.fromTypeId(stream.readByte());
        int offset = stream.readWord();
        int length = stream.readByte();
        return new UartDataRequest(type, offset, length);
    }

    public static UartDataRequest parse(byte[] frameData) {
        ExtendedByteBuffer frameBuffer = ExtendedByteBuffer.createFrom((byte[])frameData);
        frameBuffer.internal().position(2);
        UartDataType type = UartDataType.fromTypeId(frameBuffer.getUnsignedByte());
        int offset = frameBuffer.getUnsignedShort();
        int length = frameBuffer.getUnsignedByte();
        return new UartDataRequest(type, offset, length);
    }

    private UartDataRequest(UartDataType type, int offset, int length) {
        this.type = type;
        this.offset = offset;
        this.length = length;
    }

    public UartDataType getType() {
        return this.type;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }
}

