/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.esl.accesspoint.serial.FrameInputStream;
import at.mrdevelopment.esl.accesspoint.serial.UartDataType;
import at.mrdevelopment.esl.accesspoint.serial.UartFrame;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.nio.ExtendedByteBuffer;

public class UartDataInitRequest
implements UartFrame {
    public static final int COMMAND_ID = 160;
    private final UartDataType type;
    private final Version firmwareVersion;
    private final boolean extendedResponseSupported;

    public static UartDataInitRequest parse(FrameInputStream stream) throws Exception {
        UartDataType type = UartDataType.fromTypeId(stream.readByte());
        Version firmwareVersion = Version.fromByte((int)stream.readByte());
        int buildNumber = stream.readSignedWord();
        Version firmwareVersionAndBuild = new Version(firmwareVersion, buildNumber > 0 ? buildNumber : 0);
        return new UartDataInitRequest(type, firmwareVersionAndBuild, buildNumber >= 0);
    }

    public static UartDataInitRequest parse(byte[] frameData) {
        ExtendedByteBuffer frameBuffer = ExtendedByteBuffer.createFrom((byte[])frameData);
        frameBuffer.internal().position(2);
        UartDataType type = UartDataType.fromTypeId(frameBuffer.getUnsignedByte());
        Version firmwareVersion = Version.fromByte((int)frameBuffer.getUnsignedByte());
        return new UartDataInitRequest(type, firmwareVersion, false);
    }

    private UartDataInitRequest(UartDataType type, Version firmwareVersion, boolean extendedResponseSupported) {
        this.type = type;
        this.firmwareVersion = firmwareVersion;
        this.extendedResponseSupported = extendedResponseSupported;
    }

    public UartDataType getType() {
        return this.type;
    }

    public Version getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public boolean isExtendedResponseSupported() {
        return this.extendedResponseSupported;
    }
}

