/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.esl.accesspoint.serial.FrameOutputStream;
import at.mrdevelopment.esl.accesspoint.serial.UartData;
import at.mrdevelopment.esl.accesspoint.serial.UartDataType;
import at.mrdevelopment.esl.wireless.Address;
import java.io.IOException;

public class UartConfigurationData
extends UartData {
    private static final int EXTENDED_LENGTH = 8;
    private static final int LENGTH = 5;
    private final Address address;
    private final int featureSupport = 1;
    private final int coexistanceSetup = 0;
    private final int coexistanceTiming = 0;
    private final int length;

    public UartConfigurationData(Address address, int length) {
        super(UartDataType.CONFIGURATION);
        this.address = address;
        this.length = length;
    }

    @Override
    public void send(FrameOutputStream stream) throws IOException {
        stream.writeByte(163);
        stream.writeByte(this.getType().getTypeId());
        stream.writeAddress(this.address);
        stream.writeByte(0);
        if (this.length == 8) {
            stream.writeByte(1);
            stream.writeByte(0);
            stream.writeByte(0);
        }
    }

    public static int getConfigurationDataLength(boolean extendedResponseSupported) {
        return extendedResponseSupported ? 8 : 5;
    }
}

