/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.esl.accesspoint.command.DataCommand;
import at.mrdevelopment.esl.accesspoint.command.EmptyCommand;
import at.mrdevelopment.esl.accesspoint.command.SyncPacket;
import at.mrdevelopment.esl.accesspoint.command.TransmissionCommand;
import at.mrdevelopment.esl.accesspoint.serial.FrameOutputStream;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;

public class SyncPacketHelper {
    private static ESLLogger logger = ESLLogger.getLogger(SyncPacketHelper.class);

    public static void sendCommands(SyncPacket syncPacket, FrameOutputStream stream) throws IOException {
        stream.writeByte(syncPacket.getCommandType().getId() | (syncPacket.isJoinRequestAllowed() ? 2 : 0));
        int freeCommands = 3;
        if (syncPacket.getCommandType().isDataInit()) {
            syncPacket.getDataCommand().writeCommand(stream);
            freeCommands = 0;
        }
        if (freeCommands > 0) {
            for (TransmissionCommand transmissionCommand : syncPacket.getCommands()) {
                transmissionCommand.writeCommand(stream);
                --freeCommands;
            }
        }
        while (freeCommands > 0) {
            EmptyCommand.INSTANCE.writeCommand(stream);
            --freeCommands;
        }
    }

    public static void sendKeys(SyncPacket syncPacket, FrameOutputStream stream) throws IOException {
        int freeCommands = 3;
        if (syncPacket.getCommandType().isDataInit()) {
            syncPacket.getDataCommand().writeKey(stream);
            EmptyCommand.INSTANCE.writeKey(stream);
            EmptyCommand.INSTANCE.writeKey(stream);
            freeCommands = 0;
        }
        if (freeCommands > 0) {
            for (TransmissionCommand transmissionCommand : syncPacket.getCommands()) {
                transmissionCommand.writeKey(stream);
                --freeCommands;
            }
        }
        while (freeCommands > 0) {
            EmptyCommand.INSTANCE.writeKey(stream);
            --freeCommands;
        }
    }

    public static void sendScheduledData(int nextPartId, int partCount, DataCommand dataCommand, FrameOutputStream stream) throws IOException {
        int payloadSize;
        int dataOffset;
        if (dataCommand == null) {
            if (nextPartId > 0 || partCount > 0) {
                logger.warn("Data parts requested (nextPartId=%d, partCount=%d) but no data command is active", new Object[]{nextPartId, partCount});
            }
            SyncPacketHelper.sendData(nextPartId, 0, null, 0, 0, stream);
            return;
        }
        byte[] data = dataCommand.getDataBytes();
        int partsToTransmit = Math.min(partCount, (data.length - (dataOffset = nextPartId * (payloadSize = dataCommand.getPayloadSize()))) / payloadSize);
        if (partsToTransmit < partCount) {
            logger.warn("Requested more data parts than available (nextPartId=%d, partCount=%d, available=%d)", new Object[]{nextPartId, partCount, partsToTransmit});
        }
        if (dataOffset > data.length) {
            logger.error("Illegal dataOffset %d (nextPartId=%d, partCount=%d)", new Object[]{dataOffset, nextPartId, partCount});
            partsToTransmit = 0;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Sending data part (%d bytes in %d parts starting from offset %d)", new Object[]{partsToTransmit * payloadSize, partsToTransmit, dataOffset});
        }
        SyncPacketHelper.sendData(nextPartId, partsToTransmit, data, dataOffset, payloadSize, stream);
    }

    private static void sendData(int nextPartId, int partsToTransmit, byte[] data, int dataOffset, int payloadSize, FrameOutputStream stream) throws IOException {
        stream.writeWord(nextPartId);
        stream.write(partsToTransmit);
        if (partsToTransmit > 0) {
            stream.writeBytes(data, dataOffset, payloadSize * partsToTransmit);
        }
        stream.writeZeros(448 - payloadSize * partsToTransmit);
    }
}

