/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.esl.accesspoint.AccessPointProblem;
import at.mrdevelopment.esl.accesspoint.DefaultSlotIdReader;
import at.mrdevelopment.esl.accesspoint.ProtocolSettings;
import at.mrdevelopment.esl.accesspoint.ProtocolSettingsProvider;
import at.mrdevelopment.esl.accesspoint.SlotId;
import at.mrdevelopment.esl.accesspoint.SlotIdReader;
import at.mrdevelopment.esl.accesspoint.SlotPipelineProcessing;
import at.mrdevelopment.esl.accesspoint.TransmissionStatus;
import at.mrdevelopment.esl.accesspoint.WirelessTransmitter;
import at.mrdevelopment.esl.accesspoint.command.SyncCommandType;
import at.mrdevelopment.esl.accesspoint.command.SyncPacket;
import at.mrdevelopment.esl.accesspoint.serial.FrameInputStream;
import at.mrdevelopment.esl.accesspoint.serial.FrameOutputStream;
import at.mrdevelopment.esl.accesspoint.serial.SerialHelper;
import at.mrdevelopment.esl.accesspoint.serial.SyncPacketHelper;
import at.mrdevelopment.esl.accesspoint.serial.UartSlotReply;
import at.mrdevelopment.esl.accesspoint.serial.UartSlotRequest;
import at.mrdevelopment.esl.accesspoint.taskqueue.SlotPipeline;
import at.mrdevelopment.esl.core.ESLException;
import at.mrdevelopment.esl.core.TransmissionInfo;
import at.mrdevelopment.esl.wireless.EventPacket;
import at.mrdevelopment.esl.wireless.JoinRequest;
import at.mrdevelopment.esl.wireless.Reply;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import java.util.ArrayList;
import org.joda.time.DateTime;

public class SerialWirelessTransmitter
extends WirelessTransmitter {
    private static ESLLogger logger = ESLLogger.getLogger(SerialWirelessTransmitter.class);
    private SlotId latestRequestedSlotId = null;
    private SlotPipelineProcessing slotPipelineProcessing;
    private final SlotIdReader slotIdReader;
    protected boolean labelEventsEnabled;

    public SerialWirelessTransmitter(SlotPipeline slotPipeline, SlotPipelineProcessing slotPipelineProcessing, ProtocolSettingsProvider protocolSettingsProvider) {
        this(slotPipeline, slotPipelineProcessing, protocolSettingsProvider, true, new DefaultSlotIdReader());
    }

    public SerialWirelessTransmitter(SlotPipeline slotPipeline, SlotPipelineProcessing slotPipelineProcessing, ProtocolSettingsProvider protocolSettingsProvider, boolean labelEventsEnabled, SlotIdReader slotIdReader) {
        super(slotPipeline, protocolSettingsProvider);
        this.slotPipelineProcessing = slotPipelineProcessing;
        this.labelEventsEnabled = labelEventsEnabled;
        this.slotIdReader = slotIdReader;
    }

    private void reinitOrPretend(int diff, SlotId slotId) {
        if (diff > 64) {
            SlotId startSlotId = SlotPipelineProcessing.calculateStartSlotId(slotId);
            this.slotPipelineProcessing.reInitializeAndWait(startSlotId);
            logger.warn("Reinint at slot %s with start slot %s (diff = %d).", new Object[]{slotId, startSlotId, diff});
        } else {
            logger.info("Faking replies from %s (including) to %s (excluding). Slot mismatches to be expected.", new Object[]{this.latestRequestedSlotId, slotId});
            while (!slotId.isNextOf(this.latestRequestedSlotId)) {
                this.latestRequestedSlotId = this.latestRequestedSlotId.next();
                this.pretendAddReply(this.latestRequestedSlotId);
            }
        }
    }

    public void receiveNextSlot(UartSlotRequest slotRequest, UartSlotReply slotReply, boolean toSend) throws IOException, ESLException {
        int diff;
        FrameInputStream inputStream = slotRequest.getStream();
        FrameOutputStream outputStream = slotReply.getStream();
        int rawSlotId = this.slotIdReader.readRawSlotId(inputStream);
        SlotId slotId = this.slotIdReader.getSlotId(rawSlotId);
        if (logger.isDebugEnabled()) {
            logger.debug("Next slot is %s", new Object[]{slotId});
        }
        if (this.latestRequestedSlotId != null) {
            if (!slotId.isNextOf(this.latestRequestedSlotId)) {
                logger.info("reinitOrPretend = %s (latest), %s (new) - (latestProvided)", new Object[]{this.latestRequestedSlotId, slotId});
                diff = this.latestRequestedSlotId.differenceTo(slotId);
                this.reinitOrPretend(diff, slotId);
            }
        } else if (!slotId.isCycleStart()) {
            this.latestRequestedSlotId = SlotId.ZERO;
            logger.info("reinitOrPretend = %s (latest), %s (new)", new Object[]{this.latestRequestedSlotId, slotId});
            diff = this.latestRequestedSlotId.differenceTo(slotId);
            this.reinitOrPretend(diff, slotId);
        }
        this.latestRequestedSlotId = slotId;
        if (this.shutdownRequested()) {
            return;
        }
        DateTime now = DateTime.now();
        this.slotTimerTick(slotId, now);
        int requestStatusByte = inputStream.readByte();
        boolean uartReplyError = (requestStatusByte & 8) != 0;
        boolean otherSyncDetected = (requestStatusByte & 0x20) != 0;
        boolean channelOccupied = (requestStatusByte & 0x10) != 0;
        ArrayList<AccessPointProblem> problems = new ArrayList<AccessPointProblem>();
        if (uartReplyError) {
            logger.info("UART reply received too late or was corrupt (slot %s)", new Object[]{slotId});
        }
        if (otherSyncDetected) {
            problems.add(AccessPointProblem.OTHER_SYNC_DETECTED);
        }
        if (channelOccupied) {
            problems.add(AccessPointProblem.CHANNEL_OCCUPIED);
        }
        TransmissionStatus transmissionStatus = TransmissionStatus.fromCode(requestStatusByte & 7);
        TransmissionInfo transmissionInfo = inputStream.readTransmissionInfo();
        Reply[] replies = new Reply[3];
        JoinRequest[] joinRequests = new JoinRequest[5];
        EventPacket[] events = new EventPacket[5];
        for (int replySlot = 0; replySlot < 3; ++replySlot) {
            Reply reply = SerialHelper.receiveReplyPacket(inputStream, now, replySlot);
            if (reply == null) continue;
            replies[reply.getReplySlot()] = reply;
            if (!logger.isDebugEnabled()) continue;
            logger.debug(reply.toString());
        }
        for (int joinSlot = 0; joinSlot < 5; ++joinSlot) {
            JoinRequest joinRequest;
            joinRequests[joinSlot] = joinRequest = SerialHelper.receiveJoinRequest(inputStream, now);
        }
        if (this.labelEventsEnabled) {
            for (int eventSlot = 0; eventSlot < 5; ++eventSlot) {
                EventPacket eventPacket;
                events[eventSlot] = eventPacket = SerialHelper.receiveLabelEvent(inputStream, now);
            }
        }
        int nextPartId = inputStream.readWord();
        int partCount = inputStream.readByte();
        ProtocolSettings protocolSettings = this.getProtocolSettings();
        SyncPacket syncPacket = this.addRepliesAndGetSyncPacket(slotId, transmissionStatus, transmissionInfo, replies, joinRequests, events, uartReplyError, problems, now);
        if (logger.isDebugEnabled() && syncPacket.getCommandType() != SyncCommandType.EMPTY) {
            logger.debug("Slot %s: SYNC %s", new Object[]{slotId, syncPacket.getCommandType().toString()});
        }
        if (syncPacket.isValid() && toSend) {
            int replyStatusByte = SerialHelper.getReplyStatus(protocolSettings);
            int slotInfoWord = this.slotIdReader.getSlotInfoWord(rawSlotId, syncPacket);
            outputStream.writeByte(175);
            outputStream.writeWord(slotInfoWord);
            outputStream.writeByte(protocolSettings.getLogicalChannel());
            outputStream.writeByte(replyStatusByte);
            SyncPacketHelper.sendCommands(syncPacket, outputStream);
            SyncPacketHelper.sendKeys(syncPacket, outputStream);
            SyncPacketHelper.sendScheduledData(nextPartId, partCount, this.getActiveDataCommand(), outputStream);
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        logger.info("Serial wireless transmitter terminated");
    }
}

