/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.esl.accesspoint.AccessPoint;
import at.mrdevelopment.esl.accesspoint.serial.FrameOutputStream;
import at.mrdevelopment.esl.accesspoint.serial.UartConfigurationData;
import at.mrdevelopment.esl.accesspoint.serial.UartDataFinished;
import at.mrdevelopment.esl.accesspoint.serial.UartDataFinishedReply;
import at.mrdevelopment.esl.accesspoint.serial.UartDataInit;
import at.mrdevelopment.esl.accesspoint.serial.UartDataInitRequest;
import at.mrdevelopment.esl.accesspoint.serial.UartDataRequest;
import at.mrdevelopment.esl.accesspoint.serial.UartDataType;
import at.mrdevelopment.esl.accesspoint.serial.UartExtendedConfigurationData;
import at.mrdevelopment.esl.accesspoint.serial.UartExtendedDataInit;
import at.mrdevelopment.esl.accesspoint.serial.UartExtendedDataInitRequest;
import at.mrdevelopment.esl.accesspoint.serial.UartExtendedDataRequest;
import at.mrdevelopment.esl.accesspoint.serial.UartStatus;
import at.mrdevelopment.esl.accesspoint.serial.UartStreamData;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.FirmwareImage;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.firmware.Firmware;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import java.util.Arrays;

public class SerialTransmitterConfiguration {
    static ESLLogger logger = ESLLogger.getLogger(SerialTransmitterConfiguration.class);
    private final AccessPoint accessPoint;

    public SerialTransmitterConfiguration(AccessPoint accessPoint) {
        this.accessPoint = accessPoint;
    }

    public void receiveUartDataInit(UartDataInitRequest dataInit, FrameOutputStream outputStream) throws IOException {
        if (dataInit.getType() == UartDataType.CONFIGURATION) {
            this.sendConfigurationDataInit(dataInit, outputStream);
        } else if (dataInit.getType() == UartDataType.ENTER_WISPY) {
            this.sendWiSpyDataInit(dataInit, outputStream);
        } else {
            this.sendFirmwareDataInit(dataInit, outputStream);
        }
    }

    public void receiveUartData(UartDataRequest data, FrameOutputStream outputStream) throws IOException {
        if (data.getType() == UartDataType.CONFIGURATION) {
            this.sendConfigurationData(data, outputStream);
        } else {
            this.sendFirmwareData(data, outputStream);
        }
    }

    public void receiveExtendedUartDataInit(UartExtendedDataInitRequest dataInit, FrameOutputStream outputStream) throws IOException {
        this.sendExtendedConfigurationDataInit(dataInit, outputStream);
    }

    public void receiveExtendedUartData(UartExtendedDataRequest data, FrameOutputStream outputStream) throws IOException {
        this.sendExtendedConfigurationData(outputStream);
    }

    public void receiveUartFinished(UartDataFinished finished, FrameOutputStream outputStream) throws IOException {
        logger.info("Finished sending %s with status %s", new Object[]{finished.getType(), finished.getStatus()});
        UartDataFinishedReply reply = new UartDataFinishedReply(finished.getType(), UartStatus.OK);
        reply.send(outputStream);
    }

    private void sendConfigurationDataInit(UartDataInitRequest dataInit, FrameOutputStream outputStream) throws IOException {
        this.accessPoint.setFirmwareVersion(dataInit.getFirmwareVersion());
        UartDataInit reply = new UartDataInit(UartDataType.CONFIGURATION, UartConfigurationData.getConfigurationDataLength(dataInit.isExtendedResponseSupported()), dataInit.isExtendedResponseSupported(), this.accessPoint.getSoftwareVersion());
        reply.send(outputStream);
    }

    private void sendConfigurationData(UartDataRequest data, FrameOutputStream outputStream) throws IOException {
        Address transmitterAddress = Address.fromId((long)this.accessPoint.getAccessPointId());
        logger.info("Sending transmitter configuration (address %s)", new Object[]{transmitterAddress.toString()});
        UartConfigurationData reply = new UartConfigurationData(transmitterAddress, data.getLength());
        reply.send(outputStream);
    }

    private void sendExtendedConfigurationDataInit(UartExtendedDataInitRequest dataInit, FrameOutputStream outputStream) throws IOException {
        this.accessPoint.setFirmwareVersion(new Version(this.accessPoint.getFirmwareVersion(), dataInit.getSvnVersion()));
        UartExtendedDataInit reply = new UartExtendedDataInit(UartDataType.EXTENDED_CONFIGURATION, 5);
        reply.send(outputStream);
    }

    private void sendExtendedConfigurationData(FrameOutputStream outputStream) throws IOException {
        UartExtendedConfigurationData reply = new UartExtendedConfigurationData(this.accessPoint.getSoftwareVersion());
        reply.send(outputStream);
    }

    protected void sendWiSpyDataInit(UartDataInitRequest dataInit, FrameOutputStream outputStream) throws IOException {
        UartDataInit reply = new UartDataInit(dataInit.getType(), 0, dataInit.isExtendedResponseSupported(), this.accessPoint.getSoftwareVersion());
        reply.send(outputStream);
    }

    private void sendFirmwareDataInit(UartDataInitRequest dataInit, FrameOutputStream outputStream) throws IOException {
        UartDataInit reply;
        FirmwareImage firmwareImage = null;
        logger.info("RF Transmitter board %s version is %s (%d)", new Object[]{dataInit.getType(), dataInit.getFirmwareVersion(), dataInit.getFirmwareVersion().getBuild()});
        if (this.accessPoint.getFirmware() != null && !this.accessPoint.getFirmware().getVersion().isEqualOlder(dataInit.getFirmwareVersion())) {
            logger.warn("RF Transmitter board version (%s (%d)) is older than available version (%s (%d))", new Object[]{dataInit.getFirmwareVersion(), dataInit.getFirmwareVersion().getBuild(), this.accessPoint.getFirmware().getVersion(), this.accessPoint.getFirmware().getVersion().getBuild()});
        }
        if (dataInit.getType() == UartDataType.FIRMWARE_MASTER && (this.accessPoint.isNewFirmwareAvailable(dataInit.getFirmwareVersion()) || this.accessPoint.getFirmware() != null && this.accessPoint.getFirmware().getForceUpdateFlag())) {
            Firmware firmware = this.accessPoint.getFirmware();
            firmwareImage = firmware.getFirmwareImage();
            if (this.accessPoint.getFirmware().getForceUpdateFlag()) {
                this.accessPoint.getFirmware().clearForceUpdateFlag();
            }
            logger.info("Sending transmitter %s version %s of size %d", new Object[]{dataInit.getType(), firmware.getVersion(), firmwareImage.getSize()});
        }
        if (firmwareImage != null) {
            reply = new UartDataInit(dataInit.getType(), firmwareImage.getSize(), dataInit.isExtendedResponseSupported(), this.accessPoint.getSoftwareVersion());
            reply.send(outputStream);
        } else {
            reply = new UartDataInit(dataInit.getType(), 0, dataInit.isExtendedResponseSupported(), this.accessPoint.getSoftwareVersion());
            reply.send(outputStream);
        }
    }

    private void sendFirmwareData(UartDataRequest request, FrameOutputStream outputStream) throws IOException {
        FirmwareImage firmwareImage = null;
        if (request.getType() == UartDataType.FIRMWARE_MASTER && this.accessPoint.getFirmware() != null) {
            firmwareImage = this.accessPoint.getFirmware().getFirmwareImage();
        }
        if (firmwareImage != null && request.getLength() > 0) {
            byte[] data = Arrays.copyOfRange(firmwareImage.getBytes(), request.getOffset(), request.getOffset() + request.getLength());
            UartStreamData reply = new UartStreamData(request.getType(), data);
            reply.send(outputStream);
        } else {
            UartStreamData reply = new UartStreamData(request.getType(), new byte[0]);
            reply.send(outputStream);
        }
    }

    protected AccessPoint getAccessPoint() {
        return this.accessPoint;
    }
}

