/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.esl.accesspoint.ProtocolSettings;
import at.mrdevelopment.esl.accesspoint.serial.FrameInputStream;
import at.mrdevelopment.esl.accesspoint.serial.FrameOutputStream;
import at.mrdevelopment.esl.accesspoint.serial.SerialWirelessTransmitter;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.EventPacket;
import at.mrdevelopment.esl.wireless.JoinRequest;
import at.mrdevelopment.esl.wireless.Reply;
import at.mrdevelopment.esl.wireless.RxMetrics;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import org.joda.time.DateTime;

public class SerialHelper {
    private static ESLLogger logger = ESLLogger.getLogger(SerialWirelessTransmitter.class);
    public static final int PROTOCOL_VERSION = 3;
    public static final int PROTOCOL_ID_CONSUMER = 1;
    public static final int PROTOCOL_ID_RETAIL = 0;
    public static final int PROTOCOL_ID_PROFILES = 2;
    public static final int HEADER_ACK_MASK = 16;
    public static final int REPLY_SLOT_MASK = 3;
    public static final int MAX_PAYLOAD_SIZE = 32;
    public static final int MAX_WINDOW_SIZE = 14;
    public static final int TRANSMISSION_STATUS_MASK = 7;
    public static final int UART_REQUEST_LAST_SLOT_REPLY_ERROR_MASK = 8;
    public static final int UART_REQUEST_OTHER_SYNC_DETECTED_MASK = 32;
    public static final int UART_REQUEST_CHANNEL_OCCUPIED_MASK = 16;
    public static final int UART_REQUEST_JOIN_REQUEST_ALLOWED = 2;
    private static final Reply EMPTY_REPLY = new Reply(Address.UNDEFINED, false, 0, 0, new byte[4]);
    private static final JoinRequest EMPTY_JOIN_REQUEST = new JoinRequest(Address.UNDEFINED);
    private static final EventPacket EMPTY_EVENT_PACKET = new EventPacket(Address.UNDEFINED, 0, 0);

    public static int getReplyStatus(ProtocolSettings settings) {
        int replyStatus = SerialHelper.getStatusFlag(settings.isSyncEnabled(), 0) | SerialHelper.getStatusFlag(settings.isIdentifyModeEnabled(), 1) | settings.getProtocolId() << 2 | SerialHelper.getStatusFlag(settings.isJoinForbidden(), 4) | settings.getRadioOutputPowerLevel().getOutputPowerSettingByte() << 5;
        return replyStatus;
    }

    public static int getStatusFlag(boolean value, int bitIndex) {
        return value ? 1 << bitIndex : 0;
    }

    public static Reply receiveReplyPacket(FrameInputStream stream, DateTime now, int outerReplySlot) throws IOException {
        Address senderAddress = stream.readAddress();
        RxMetrics rxMetrics = stream.readRxMetrics();
        int version = stream.readByte();
        int header = stream.readByte();
        int replyFlags = stream.readByte();
        if (version == 0 && header == 0) {
            stream.skipBytes(4);
            return null;
        }
        if (version != 7 && version != 3 && version != 11) {
            logger.warn("Received reply packet with unexpected version %d", new Object[]{version});
            stream.skipBytes(4);
            return null;
        }
        boolean acknowledge = (header & 0x10) != 0;
        int replySlot = header & 3;
        if (replySlot == 3) {
            byte[] tempArray = new byte[4];
            stream.read(tempArray);
            logger.error("Received reply packet with invalid replySlot (outerReplySlot=%d): header=%02X, version=%02X, replySlot=%d, following bytes afterwards: %02X, %02X, %02X, %02X!", new Object[]{outerReplySlot, header, version, replySlot, tempArray[0], tempArray[1], tempArray[2], tempArray[3]});
            return null;
        }
        int commandId = replyFlags & 0xF;
        byte[] data = new byte[4];
        stream.readBytes(data, 0, 4);
        Reply reply = new Reply(Address.UNDEFINED, acknowledge, replySlot, commandId, data);
        reply.setSenderAddress(senderAddress);
        reply.setRxMetrics(rxMetrics);
        return reply;
    }

    public static JoinRequest receiveJoinRequest(FrameInputStream stream, DateTime now) throws IOException {
        Address senderAddress = stream.readAddress();
        if (senderAddress.isLabel()) {
            JoinRequest joinRequest = new JoinRequest(Address.UNDEFINED);
            joinRequest.setSenderAddress(senderAddress);
            return joinRequest;
        }
        return null;
    }

    public static EventPacket receiveLabelEvent(FrameInputStream stream, DateTime now) throws IOException {
        Address senderAddress = stream.readAddress();
        int eventType = stream.readByte();
        int eventData = stream.readWord();
        stream.readWord();
        if (senderAddress.isLabel()) {
            EventPacket eventPacket = new EventPacket(Address.UNDEFINED, eventType, eventData);
            eventPacket.setSenderAddress(senderAddress);
            return eventPacket;
        }
        return null;
    }

    public static void sendReplyPacket(Reply reply, FrameOutputStream stream) throws IOException {
        if (reply == null) {
            SerialHelper.inner_sendReplyPacket(EMPTY_REPLY, stream);
        } else {
            SerialHelper.inner_sendReplyPacket(reply, stream);
        }
    }

    private static void inner_sendReplyPacket(Reply reply, FrameOutputStream stream) throws IOException {
        stream.writeAddress(reply.getSenderAddress());
        stream.writeRxMetrics(reply.getRxMetrics());
        stream.writeByte(reply == EMPTY_REPLY ? 0 : 3);
        int header = 0x13 & reply.getReplySlot() | (reply.isAcknowledged() ? 16 : 0);
        stream.write(header);
        stream.write(reply.getCommandId() & 0xF);
        stream.write(reply.getData());
    }

    public static void sendJoinRequest(JoinRequest request, FrameOutputStream stream) throws IOException {
        if (request == null) {
            SerialHelper.inner_sendJoinRequest(EMPTY_JOIN_REQUEST, stream);
        } else {
            SerialHelper.inner_sendJoinRequest(request, stream);
        }
    }

    private static void inner_sendJoinRequest(JoinRequest request, FrameOutputStream stream) throws IOException {
        stream.writeAddress(request.getSenderAddress());
    }

    public static void sendLabelEvent(EventPacket packet, FrameOutputStream stream) throws IOException {
        if (packet == null) {
            SerialHelper.inner_sendLabelEvent(EMPTY_EVENT_PACKET, stream);
        } else {
            SerialHelper.inner_sendLabelEvent(packet, stream);
        }
    }

    private static void inner_sendLabelEvent(EventPacket packet, FrameOutputStream stream) throws IOException {
        stream.writeAddress(packet.getSenderAddress());
        stream.write(packet.getEventType());
        stream.writeWord(packet.getEventData());
        stream.writeWord(0);
    }

    static {
        EMPTY_REPLY.setRxMetrics(new RxMetrics(0, 0));
        EMPTY_REPLY.setSenderAddress(Address.UNDEFINED);
        EMPTY_JOIN_REQUEST.setSenderAddress(Address.UNDEFINED);
        EMPTY_EVENT_PACKET.setSenderAddress(Address.UNDEFINED);
    }
}

