/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.esl.accesspoint.AccessPoint;
import at.mrdevelopment.esl.accesspoint.SlotPipelineProcessing;
import at.mrdevelopment.esl.accesspoint.serial.DrawGraph;
import at.mrdevelopment.esl.accesspoint.serial.FrameInputStream;
import at.mrdevelopment.esl.accesspoint.serial.FrameOutputStream;
import at.mrdevelopment.esl.accesspoint.serial.SerialConfiguration;
import at.mrdevelopment.esl.accesspoint.serial.SerialEventHandler;
import at.mrdevelopment.esl.accesspoint.serial.SerialTransmitterConfiguration;
import at.mrdevelopment.esl.accesspoint.serial.SerialTransmitterConfigurationWiSpy;
import at.mrdevelopment.esl.accesspoint.serial.UartDataFinished;
import at.mrdevelopment.esl.accesspoint.serial.UartDataInitRequest;
import at.mrdevelopment.esl.accesspoint.serial.UartDataRequest;
import at.mrdevelopment.esl.accesspoint.serial.UartLowlevelFrame;
import at.mrdevelopment.esl.accesspoint.serial.UartLowlevelOutputFrame;
import at.mrdevelopment.esl.accesspoint.serial.UartReaderWiSpy;
import at.mrdevelopment.esl.accesspoint.serial.UartWriter;
import at.mrdevelopment.esl.accesspoint.taskqueue.SlotPipeline;
import at.mrdevelopment.toolkit.Shutdownable;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.TooManyListenersException;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SerialEventHandlerWiSpy
extends SerialEventHandler
implements Shutdownable,
SerialPortEventListener {
    private final SerialConfiguration config;
    private final SerialTransmitterConfiguration transmitterConfiguration;
    private final UartReaderWiSpy uartReader;
    private final UartWriter uartWriter;
    private Queue<Byte> rssiValues;
    private List<Byte> rssiMaxValues;
    private List<Double> frequencies;
    private final int FPRECALBUFFSIZE = 1024;
    private final int SWEEP_COMPLETE = 111;
    private boolean sweepFast;
    private DrawGraph graph;
    private final SerialPort serialPort;
    private boolean configIsValid;
    private int numSweepsLeft;

    public SerialEventHandlerWiSpy(SlotPipeline slotPipeline, SlotPipelineProcessing pipelineProcessing, AccessPoint accessPoint, String portName, int baudRate, SerialConfiguration config) throws IOException, NoSuchPortException, PortInUseException, UnsupportedCommOperationException, TooManyListenersException {
        super(slotPipeline, pipelineProcessing, accessPoint, portName, baudRate);
        this.config = config;
        this.serialPort = this.connect(portName, baudRate);
        this.transmitterConfiguration = new SerialTransmitterConfigurationWiSpy(accessPoint);
        this.uartReader = new UartReaderWiSpy(this.serialPort.getInputStream(), this);
        this.uartReader.setDaemon(true);
        this.uartReader.setPriority(10);
        this.uartWriter = new UartWriter(this.serialPort.getOutputStream(), this.outputframeQueue);
        this.uartWriter.setDaemon(true);
        this.uartWriter.setPriority(10);
        this.rssiValues = new ConcurrentLinkedQueue<Byte>();
        this.rssiMaxValues = new ArrayList<Byte>();
        this.frequencies = new ArrayList<Double>();
        this.configIsValid = true;
        this.numSweepsLeft = 0;
    }

    @Override
    public void start() {
        this.uartReader.start();
        this.uartWriter.start();
    }

    @Override
    public void processFrame(UartLowlevelFrame frame) throws Exception {
        FrameInputStream inputStream = new FrameInputStream(frame.getStream());
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream(477);
        FrameOutputStream outputStream = new FrameOutputStream(byteOutputStream);
        int header = inputStream.readByte();
        if (header == 160) {
            UartDataInitRequest dataInit = UartDataInitRequest.parse(inputStream);
            this.transmitterConfiguration.receiveUartDataInit(dataInit, outputStream);
            byte[] replyData = byteOutputStream.toByteArray();
            UartLowlevelOutputFrame replyFrame = new UartLowlevelOutputFrame(replyData);
            this.outputframeQueue.addFrame(replyFrame);
        } else if (header == 162) {
            UartDataRequest data = UartDataRequest.parse(inputStream);
            this.transmitterConfiguration.receiveUartData(data, outputStream);
            byte[] replyData = byteOutputStream.toByteArray();
            UartLowlevelOutputFrame replyFrame = new UartLowlevelOutputFrame(replyData);
            this.outputframeQueue.addFrame(replyFrame);
        } else if (header == 164) {
            UartDataFinished finished = UartDataFinished.parse(inputStream);
            this.transmitterConfiguration.receiveUartFinished(finished, outputStream);
            byte[] replyData = byteOutputStream.toByteArray();
            UartLowlevelOutputFrame replyFrame = new UartLowlevelOutputFrame(replyData);
            this.outputframeQueue.addFrame(replyFrame);
        } else if (header == 172) {
            if (this.configIsValid) {
                this.sendWiSpyCommand();
                this.numSweepsLeft = this.config.getNumberOfSweeps();
                this.rssiValues.clear();
            }
        } else if (header != 174) {
            if (header == 170) {
                int b = 0;
                while ((b = inputStream.read()) != -1) {
                    if (b == 111) continue;
                    this.rssiValues.add((byte)b);
                }
            } else if (header == 171) {
                byte[] replyData;
                int b = 0;
                while ((b = inputStream.read()) != -1) {
                    if (b == 111) continue;
                    this.rssiValues.add((byte)b);
                }
                --this.numSweepsLeft;
                int index_rssiMaxValues = 0;
                if (this.rssiMaxValues.isEmpty()) {
                    this.rssiMaxValues.addAll(this.rssiValues);
                } else {
                    Iterator i$ = this.rssiValues.iterator();
                    while (i$.hasNext()) {
                        byte v = (Byte)i$.next();
                        if (this.rssiMaxValues.get(index_rssiMaxValues) < v) {
                            this.rssiMaxValues.set(index_rssiMaxValues, v);
                        }
                        ++index_rssiMaxValues;
                    }
                }
                this.graph.updateGraphValues(this.rssiValues, this.rssiMaxValues);
                if (this.numSweepsLeft > 0) {
                    this.rssiValues.clear();
                    replyData = new byte[]{78};
                    UartLowlevelOutputFrame replyFrame = new UartLowlevelOutputFrame(replyData);
                    this.outputframeQueue.addFrame(replyFrame);
                } else {
                    replyData = new byte[]{69};
                    UartLowlevelOutputFrame replyFrame = new UartLowlevelOutputFrame(replyData);
                    this.outputframeQueue.addFrame(replyFrame);
                }
            }
        }
    }

    private void sendWiSpyCommand() {
        int i;
        byte[] replyData = new byte[13];
        String sfinal = "57535020";
        String numsteps = this.getNumFREQsteps();
        sfinal = sfinal + this.getFlags(Integer.parseInt(numsteps, 16));
        sfinal = sfinal + this.getFREQ();
        sfinal = sfinal + numsteps;
        sfinal = sfinal + this.getDeltaFREQ();
        this.frequencies = new ArrayList<Double>();
        this.rssiMaxValues.clear();
        for (i = 0; i < Integer.parseInt(numsteps, 16); ++i) {
            this.frequencies.add((double)this.config.getStartFrequency() + (double)this.getDeltaFrequency() * (double)i);
        }
        this.graph = new DrawGraph(this.frequencies, this.sweepFast);
        for (i = 0; i < replyData.length * 2; i += 2) {
            replyData[i / 2] = (byte)(Integer.parseInt(sfinal.substring(i, i + 1), 16) * 16);
            int n = i / 2;
            replyData[n] = (byte)(replyData[n] + (byte)Integer.parseInt(sfinal.substring(i + 1, i + 2), 16));
        }
        this.configIsValid = false;
        UartLowlevelOutputFrame replyFrame = new UartLowlevelOutputFrame(replyData);
        this.outputframeQueue.addFrame(replyFrame);
    }

    private String getFREQ() {
        BigInteger startFreq = BigInteger.valueOf(this.config.getStartFrequency());
        startFreq = startFreq.multiply(BigInteger.valueOf(2L).pow(16));
        startFreq = startFreq.divide(BigInteger.valueOf(10L).pow(6).multiply(BigInteger.valueOf(26L)));
        String startFreqString = Integer.toHexString(startFreq.intValue());
        int l = startFreqString.length();
        for (int i = 0; i < 6 - l; ++i) {
            startFreqString = "0" + startFreqString;
        }
        return startFreqString;
    }

    private long getDeltaFrequency() {
        long deltaFrequency = 0L;
        long l = this.config.getEndFrequency() - this.config.getStartFrequency();
        this.getClass();
        deltaFrequency = l / 1024L;
        return deltaFrequency;
    }

    private String getDeltaFREQ() {
        BigInteger deltaFreq = BigInteger.valueOf(this.getDeltaFrequency());
        deltaFreq = deltaFreq.multiply(BigInteger.valueOf(2L).pow(16));
        deltaFreq = deltaFreq.divide(BigInteger.valueOf(10L).pow(6).multiply(BigInteger.valueOf(26L)));
        String deltaFreqString = Integer.toHexString(deltaFreq.intValue());
        int l = deltaFreqString.length();
        for (int i = 0; i < 6 - l; ++i) {
            deltaFreqString = "0" + deltaFreqString;
        }
        return deltaFreqString;
    }

    private String getNumFREQsteps() {
        String numstepsString = Integer.toHexString(1024);
        int l = numstepsString.length();
        for (int i = 0; i < 4 - l; ++i) {
            numstepsString = "0" + numstepsString;
        }
        return numstepsString;
    }

    private String getFlags(int numsteps) {
        int flags = this.config.getFilterBandwidth().getExponent() << 6;
        flags |= this.config.getFilterBandwidth().getMantissa() << 4;
        if (numsteps > 1024) {
            flags &= 0xFFFFFFFE;
            this.sweepFast = false;
        } else {
            flags |= 1;
            this.sweepFast = true;
        }
        String flagsString = Integer.toHexString(flags);
        int l = flagsString.length();
        for (int i = 0; i < 2 - l; ++i) {
            flagsString = "0" + flagsString;
        }
        return flagsString;
    }

    @Override
    public BufferedImage getResult() {
        if (this.graph == null) {
            return null;
        }
        this.graph.createGraph();
        BufferedImage tmpImage = null;
        tmpImage = this.graph.getGraph();
        return tmpImage;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.uartReader.shutdown();
        this.uartWriter.shutdown();
        this.serialPort.close();
    }
}

