/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.esl.accesspoint.AccessPoint;
import at.mrdevelopment.esl.accesspoint.SlotPipelineProcessing;
import at.mrdevelopment.esl.accesspoint.serial.FrameInputStream;
import at.mrdevelopment.esl.accesspoint.serial.FrameOutputStream;
import at.mrdevelopment.esl.accesspoint.serial.SerialEventHandler;
import at.mrdevelopment.esl.accesspoint.serial.SerialTransmitterConfiguration;
import at.mrdevelopment.esl.accesspoint.serial.UartDataFinished;
import at.mrdevelopment.esl.accesspoint.serial.UartDataInitRequest;
import at.mrdevelopment.esl.accesspoint.serial.UartDataRequest;
import at.mrdevelopment.esl.accesspoint.serial.UartExtendedDataInitRequest;
import at.mrdevelopment.esl.accesspoint.serial.UartExtendedDataRequest;
import at.mrdevelopment.esl.accesspoint.serial.UartFrame;
import at.mrdevelopment.esl.accesspoint.serial.UartLowlevelFrame;
import at.mrdevelopment.esl.accesspoint.serial.UartLowlevelOutputFrame;
import at.mrdevelopment.esl.accesspoint.serial.UartReader;
import at.mrdevelopment.esl.accesspoint.serial.UartSlotReply;
import at.mrdevelopment.esl.accesspoint.serial.UartSlotRequest;
import at.mrdevelopment.esl.accesspoint.serial.UartWriter;
import at.mrdevelopment.esl.accesspoint.taskqueue.SlotPipeline;
import at.mrdevelopment.toolkit.Shutdownable;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.TooManyListenersException;

public class SerialEventHandlerStd
extends SerialEventHandler
implements Shutdownable,
SerialPortEventListener {
    private final UartReader uartReader;
    private final UartWriter uartWriter;
    private final SerialTransmitterConfiguration transmitterConfiguration;
    private final SerialPort serialPort;

    public SerialEventHandlerStd(SlotPipeline slotPipeline, SlotPipelineProcessing pipelineProcessing, AccessPoint accessPoint, String portName, int baudRate) throws IOException, NoSuchPortException, PortInUseException, UnsupportedCommOperationException, TooManyListenersException {
        super(slotPipeline, pipelineProcessing, accessPoint, portName, baudRate);
        this.serialPort = this.connect(portName, baudRate);
        String receiveTimeout = System.getProperty("serial.receivetimeout");
        String receiveThreshold = System.getProperty("serial.receivethreshold");
        if (receiveTimeout != null && !receiveTimeout.isEmpty() && Boolean.valueOf(receiveTimeout).booleanValue()) {
            this.serialPort.disableReceiveTimeout();
        }
        if (receiveThreshold != null && !receiveThreshold.isEmpty()) {
            this.serialPort.enableReceiveThreshold(Integer.valueOf(receiveThreshold).intValue());
        }
        this.transmitterConfiguration = new SerialTransmitterConfiguration(accessPoint);
        this.uartReader = new UartReader(this.serialPort.getInputStream(), this);
        this.uartReader.setName(String.format("UartReader - %s", accessPoint.getName()));
        this.uartReader.setDaemon(true);
        this.uartReader.setPriority(10);
        this.uartWriter = new UartWriter(this.serialPort.getOutputStream(), this.outputframeQueue);
        this.uartWriter.setName(String.format("UartWriter - %s", accessPoint.getName()));
        this.uartWriter.setDaemon(true);
        this.uartWriter.setPriority(10);
    }

    @Override
    public void start() {
        this.uartReader.start();
        this.uartWriter.start();
    }

    @Override
    public void processFrame(UartLowlevelFrame frame) throws Exception {
        UartFrame data;
        UartFrame dataInit;
        FrameInputStream inputStream = new FrameInputStream(frame.getStream());
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream(477);
        FrameOutputStream outputStream = new FrameOutputStream(byteOutputStream);
        int header = inputStream.readByte();
        if (header == 174) {
            UartSlotRequest slotRequest = new UartSlotRequest(inputStream);
            UartSlotReply slotReply = new UartSlotReply(outputStream);
            this.wirelessTransmitter.receiveNextSlot(slotRequest, slotReply, true);
        } else if (header == 160) {
            dataInit = UartDataInitRequest.parse(inputStream);
            this.transmitterConfiguration.receiveUartDataInit((UartDataInitRequest)dataInit, outputStream);
        } else if (header == 162) {
            data = UartDataRequest.parse(inputStream);
            this.transmitterConfiguration.receiveUartData((UartDataRequest)data, outputStream);
        } else if (header == 166) {
            dataInit = UartExtendedDataInitRequest.parse(inputStream);
            this.transmitterConfiguration.receiveExtendedUartDataInit((UartExtendedDataInitRequest)dataInit, outputStream);
        } else if (header == 168) {
            data = UartExtendedDataRequest.parse(inputStream);
            this.transmitterConfiguration.receiveExtendedUartData((UartExtendedDataRequest)data, outputStream);
        } else if (header == 164) {
            UartDataFinished finished = UartDataFinished.parse(inputStream);
            this.transmitterConfiguration.receiveUartFinished(finished, outputStream);
        }
        byte[] replyData = byteOutputStream.toByteArray();
        UartLowlevelOutputFrame replyFrame = new UartLowlevelOutputFrame(replyData);
        this.outputframeQueue.addFrame(replyFrame);
    }

    @Override
    public BufferedImage getResult() {
        return null;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.uartReader.shutdown();
        this.uartWriter.shutdown();
        this.serialPort.close();
    }
}

