/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.esl.accesspoint.AccessPoint;
import at.mrdevelopment.esl.accesspoint.SlotPipelineProcessing;
import at.mrdevelopment.esl.accesspoint.serial.FrameQueue;
import at.mrdevelopment.esl.accesspoint.serial.SerialWirelessTransmitter;
import at.mrdevelopment.esl.accesspoint.serial.UartLowlevelFrame;
import at.mrdevelopment.esl.accesspoint.taskqueue.SlotPipeline;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ESLLogger;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.TooManyListenersException;

public abstract class SerialEventHandler
implements Shutdownable,
SerialPortEventListener {
    static ESLLogger logger = ESLLogger.getLogger(SerialEventHandler.class);
    private static final int OPEN_PORT_TIMEOUT = 2000;
    public static final String SERIAL_RECEIVE_THRESHOLD = "serial.receivethreshold";
    public static final String SERIAL_DISABLE_RECEIVE_TIMEOUT = "serial.receivetimeout";
    protected final SerialWirelessTransmitter wirelessTransmitter;
    protected final FrameQueue outputframeQueue = new FrameQueue();

    public SerialEventHandler(SlotPipeline slotPipeline, SlotPipelineProcessing slotPipelineProcessing, AccessPoint accessPoint, String portName, int baudRate) throws IOException, NoSuchPortException, PortInUseException, UnsupportedCommOperationException, TooManyListenersException {
        this.wirelessTransmitter = new SerialWirelessTransmitter(slotPipeline, slotPipelineProcessing, accessPoint);
    }

    public abstract void start();

    protected SerialPort connect(String portName, int baudRate) throws IOException, NoSuchPortException, PortInUseException, UnsupportedCommOperationException, TooManyListenersException {
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)portName);
        CommPort commPort = portIdentifier.open(this.getClass().getName(), 2000);
        SerialPort serialPort = (SerialPort)commPort;
        serialPort.setSerialPortParams(baudRate, 8, 1, 0);
        serialPort.setFlowControlMode(0);
        serialPort.addEventListener((SerialPortEventListener)this);
        serialPort.notifyOnFramingError(true);
        serialPort.notifyOnOverrunError(true);
        serialPort.notifyOnBreakInterrupt(true);
        return serialPort;
    }

    public void serialEvent(SerialPortEvent event) {
        if (event.getEventType() == 9) {
            logger.info("Event: Framing error");
        } else if (event.getEventType() == 7) {
            logger.info("Event: Overrun error");
        } else if (event.getEventType() == 10) {
            logger.info("Event: Break interrupt");
        }
    }

    public abstract BufferedImage getResult();

    public abstract void processFrame(UartLowlevelFrame var1) throws Exception;

    public void shutdown() {
        this.wirelessTransmitter.shutdown();
        logger.info("Wireless transmitter terminated");
    }
}

