/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.esl.accesspoint.AccessPoint;
import at.mrdevelopment.esl.accesspoint.SlotPipelineProcessing;
import at.mrdevelopment.esl.accesspoint.serial.SerialConfiguration;
import at.mrdevelopment.esl.accesspoint.serial.SerialEventHandler;
import at.mrdevelopment.esl.accesspoint.serial.SerialEventHandlerStd;
import at.mrdevelopment.esl.accesspoint.serial.SerialEventHandlerWiSpy;
import at.mrdevelopment.esl.accesspoint.taskqueue.SlotPipeline;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.TooManyListenersException;

public class SerialConfigurationManager
implements Shutdownable {
    private final SlotPipeline slotPipeline;
    private final SlotPipelineProcessing slotPipelineProcessing;
    private final AccessPoint accessPoint;
    private final String serialPortName;
    private final int baudRate;
    private final boolean simulated;
    private SerialConfiguration serialConfiguration;
    private SerialEventHandler serialEventHandler;

    public SerialConfigurationManager(SlotPipeline slotPipeline, SlotPipelineProcessing slotPipelineProcessing, AccessPoint accessPoint, String serialPortName, int baudRate, boolean simulated) throws InitializationException {
        this.slotPipeline = slotPipeline;
        this.slotPipelineProcessing = slotPipelineProcessing;
        this.accessPoint = accessPoint;
        this.serialPortName = serialPortName;
        this.baudRate = baudRate;
        this.simulated = simulated;
        this.serialConfiguration = new SerialConfiguration();
        try {
            this.startSerialEventHandler(this.serialConfiguration);
        }
        catch (Exception exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    private void initAndStartSerialEventHandler() throws IOException, NoSuchPortException, PortInUseException, UnsupportedCommOperationException, TooManyListenersException {
        if (!this.simulated && this.serialEventHandler == null) {
            this.serialEventHandler = new SerialEventHandlerStd(this.slotPipeline, this.slotPipelineProcessing, this.accessPoint, this.serialPortName, this.baudRate);
            this.serialEventHandler.start();
        }
    }

    private void initAndStartSerialEventHandlerWiSpy() throws IOException, NoSuchPortException, PortInUseException, UnsupportedCommOperationException, TooManyListenersException {
        if (!this.simulated && this.serialEventHandler == null) {
            this.serialEventHandler = new SerialEventHandlerWiSpy(this.slotPipeline, this.slotPipelineProcessing, this.accessPoint, this.serialPortName, this.baudRate, this.serialConfiguration);
            this.serialEventHandler.start();
        }
    }

    private void startSerialEventHandler(SerialConfiguration serialConfiguration) throws InitializationException {
        if (this.serialEventHandler != null) {
            this.serialEventHandler.shutdown();
            this.serialEventHandler = null;
        }
        if (serialConfiguration.isWiSpyEnabled()) {
            try {
                this.initAndStartSerialEventHandlerWiSpy();
            }
            catch (Exception exc) {
                throw new InitializationException((Throwable)exc, "Could not start serial event handler", new Object[0]);
            }
        }
        try {
            this.initAndStartSerialEventHandler();
        }
        catch (Exception exc) {
            throw new InitializationException((Throwable)exc, "Could not start serial event handler", new Object[0]);
        }
    }

    public void shutdown() {
        if (this.serialEventHandler != null) {
            this.serialEventHandler.shutdown();
        }
    }

    public synchronized BufferedImage getImage() {
        return this.serialEventHandler != null ? this.serialEventHandler.getResult() : null;
    }

    public synchronized SerialConfiguration getSerialConfiguration() {
        return this.serialConfiguration;
    }

    public synchronized boolean setSerialConfiguration(SerialConfiguration serialConfiguration) throws InitializationException {
        if (!this.serialConfiguration.equals(serialConfiguration)) {
            this.serialConfiguration = serialConfiguration;
            this.shutdown();
            try {
                this.startSerialEventHandler(serialConfiguration);
            }
            catch (InitializationException exc) {
                throw new InitializationException("Could not start serial event handler", new Object[]{exc});
            }
            return true;
        }
        return false;
    }
}

