/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.esl.core.TransmissionInfo;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.RxMetrics;
import at.mrdevelopment.toolkit.Version;
import java.io.IOException;
import java.io.OutputStream;

public class FrameOutputStream
extends OutputStream {
    private final OutputStream outputStream;

    public FrameOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void write(int data) throws IOException {
        this.outputStream.write(data);
    }

    public void writeBoolean(boolean value) throws IOException {
        this.outputStream.write(value ? 1 : 0);
    }

    public void writeByte(int data) throws IOException {
        this.outputStream.write(data);
    }

    public void writeWord(int data) throws IOException {
        this.outputStream.write(data);
        this.outputStream.write(data >> 8);
    }

    public void writeInteger24(int data) throws IOException {
        this.outputStream.write(data);
        this.outputStream.write(data >> 8);
        this.outputStream.write(data >> 16);
    }

    public void writeInteger32(int data) throws IOException {
        this.outputStream.write(data);
        this.outputStream.write(data >> 8);
        this.outputStream.write(data >> 16);
        this.outputStream.write(data >> 24);
    }

    public void writeAddress(Address address) throws IOException {
        this.outputStream.write(address.getSimplicitiAddress());
    }

    public void writeAddressPart(Address address) throws IOException {
        this.outputStream.write(address.getSimplicitiAddressPart());
    }

    public void writeBytes(byte[] dataBytes, int offset, int length) throws IOException {
        this.outputStream.write(dataBytes, offset, length);
    }

    public void writeBytes(byte[] dataBytes) throws IOException {
        this.writeBytes(dataBytes, 0, dataBytes.length);
    }

    public void writeRxMetrics(RxMetrics metrics) throws IOException {
        this.writeByte(metrics.getRssi());
        this.writeByte(metrics.getLqi());
    }

    public void writeTransmissionInfo(TransmissionInfo transmissionInfo) throws IOException {
        this.writeRxMetrics(transmissionInfo.getLabelRxMetrics());
        this.writeRxMetrics(transmissionInfo.getTransmitterRxMetrics());
        this.writeWord(transmissionInfo.getPacketsTransmitted());
    }

    public void writeZeros(int length) throws IOException {
        for (int index = 0; index < length; ++index) {
            this.outputStream.write(0);
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void writeVersion(Version softwareVersion) throws IOException {
        byte[] versionData = new byte[]{softwareVersion.getMainRelease(), softwareVersion.getSubRelease(), softwareVersion.getPatchLevel()};
        this.writeBytes(versionData);
        this.writeWord(softwareVersion.getBuild());
    }
}

