/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import at.mrdevelopment.esl.core.TransmissionInfo;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.RxMetrics;
import java.io.IOException;
import java.io.InputStream;

public class FrameInputStream
extends InputStream {
    private final InputStream inputStream;
    private final byte[] simplicitiAddress = new byte[4];

    public FrameInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    public int readByte() throws IOException {
        return this.inputStream.read();
    }

    public int readSignedByte() throws IOException {
        int value = this.readByte();
        return ((value & 0x80) == 128 ? -128 : 0) + (value & 0x7F);
    }

    public int readWord() throws IOException {
        return this.inputStream.read() | this.inputStream.read() << 8;
    }

    public int readSignedWord() throws IOException {
        int value = this.inputStream.read() | this.inputStream.read() << 8;
        return ((value & 0x8000) == 32768 ? Short.MIN_VALUE : 0) + (value & Short.MAX_VALUE);
    }

    public int readInteger24() throws IOException {
        return this.inputStream.read() | this.inputStream.read() << 8 | this.inputStream.read() << 16;
    }

    public int readWordLittleEndian() throws IOException {
        return this.inputStream.read() << 8 | this.inputStream.read();
    }

    public int read32BitWord() throws IOException {
        return this.inputStream.read() | this.inputStream.read() << 8 | this.inputStream.read() << 16 | this.inputStream.read() << 24;
    }

    public int read32BitWordLittleEndian() throws IOException {
        return this.inputStream.read() << 24 | this.inputStream.read() << 16 | this.inputStream.read() << 8 | this.inputStream.read();
    }

    public int readBytes(byte[] dataBytes, int offset, int length) throws IOException {
        int bytesRead;
        for (bytesRead = 0; bytesRead < length; bytesRead += this.inputStream.read(dataBytes, offset + bytesRead, length - bytesRead)) {
        }
        return bytesRead;
    }

    public Address readAddress() throws IOException {
        this.readBytes(this.simplicitiAddress, 0, 4);
        Address temp = Address.fromSimplicitiAddress((byte[])this.simplicitiAddress);
        return temp;
    }

    public Address readAddressPart(int addressExtension) throws IOException {
        this.simplicitiAddress[0] = (byte)addressExtension;
        this.readBytes(this.simplicitiAddress, 1, 3);
        return Address.fromSimplicitiAddress((byte[])this.simplicitiAddress);
    }

    public RxMetrics readRxMetrics() throws IOException {
        int rssi = this.readSignedByte();
        int lqi = this.readByte();
        return RxMetrics.getFrom((int)rssi, (int)lqi);
    }

    public TransmissionInfo readTransmissionInfo() throws IOException {
        RxMetrics labelRxMetrics = this.readRxMetrics();
        RxMetrics transmitterRxMetrics = this.readRxMetrics();
        int txPacketCount = this.readWord();
        return new TransmissionInfo(labelRxMetrics, transmitterRxMetrics, txPacketCount);
    }

    public long skipBytes(int length) throws IOException {
        long bytesSkipped;
        for (bytesSkipped = 0L; bytesSkipped < (long)length; bytesSkipped += this.inputStream.skip((long)length - bytesSkipped)) {
        }
        return bytesSkipped;
    }
}

