/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.serial;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JPanel;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DrawGraph
extends JPanel {
    private int padding = 25;
    private int labelPadding = 40;
    private Color lineColor = new Color(44, 102, 230, 200);
    private Color lineColorMaxVal = new Color(255, 5, 5, 100);
    private Color gridColor = new Color(200, 200, 200, 200);
    private int pointWidth = 4;
    private int numberYDivisions = 10;
    private Queue<Byte> rssiValues = new ConcurrentLinkedQueue<Byte>();
    private List<Byte> rssiMaxValues;
    private List<Double> frequencies;
    private final boolean sweepFast;
    private Queue<BufferedImage> imageQueue;
    private final DateTimeFormatter fmt;

    public DrawGraph(List<Double> frequencies, boolean sweepFast) {
        for (int i = 0; i < frequencies.size(); ++i) {
            this.rssiValues.add((byte)-120);
        }
        this.rssiMaxValues = new ArrayList<Byte>();
        this.rssiMaxValues.addAll(this.rssiValues);
        this.frequencies = frequencies;
        this.sweepFast = sweepFast;
        this.fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd (hh:mm)");
        this.imageQueue = new ConcurrentLinkedQueue<BufferedImage>();
        this.setPreferredSize(new Dimension(1280, 800));
        this.setSize(this.getPreferredSize());
        BufferedImage bi = new BufferedImage(1280, 800, 2);
        Graphics2D g = bi.createGraphics();
        this.paintComponent(g);
        g.dispose();
        this.imageQueue.add(bi);
    }

    public void updateGraphValues(Queue<Byte> rssiValues, List<Byte> rssiMaxValues) {
        this.rssiValues = rssiValues;
        this.rssiMaxValues = rssiMaxValues;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int x1;
        int i;
        int y1;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double xScale = ((double)this.getWidth() - (double)(2 * this.padding) - (double)this.labelPadding) / (double)(this.frequencies.size() - 1);
        double yScale = ((double)this.getHeight() - (double)(2 * this.padding) - (double)this.labelPadding) / (this.getMaxScore() + 120.0);
        Iterator itrRSSI = this.rssiValues.iterator();
        Iterator<Byte> itrRSSImax = this.rssiMaxValues.iterator();
        double maxScore = this.getMaxScore();
        int index = 0;
        ArrayList<Point> graphPoints = new ArrayList<Point>();
        while (itrRSSI.hasNext()) {
            int x12 = (int)((double)index * xScale + (double)this.padding + (double)this.labelPadding);
            int y12 = (int)((maxScore - (double)((Byte)itrRSSI.next()).byteValue()) * yScale + (double)this.padding);
            graphPoints.add(new Point(x12, y12));
            ++index;
        }
        index = 0;
        ArrayList<Point> graphPointsMax = new ArrayList<Point>();
        while (itrRSSImax.hasNext()) {
            int x13 = (int)((double)index * xScale + (double)this.padding + (double)this.labelPadding);
            int y13 = (int)((maxScore - (double)itrRSSImax.next().byteValue()) * yScale + (double)this.padding);
            graphPointsMax.add(new Point(x13, y13));
            ++index;
        }
        g2.setColor(Color.WHITE);
        g2.fillRect(this.padding + this.labelPadding, this.padding, this.getWidth() - 2 * this.padding - this.labelPadding, this.getHeight() - 2 * this.padding - this.labelPadding);
        g2.setColor(Color.BLACK);
        String imageInfo = new String();
        imageInfo = this.sweepFast ? imageInfo + "Fast sweep " : imageInfo + "Slow sweep ";
        DateTime dt = new DateTime();
        imageInfo = imageInfo + this.fmt.print((ReadableInstant)dt);
        g2.drawString(imageInfo, this.padding + this.labelPadding + 10, this.padding);
        g2.setColor(Color.lightGray);
        g2.drawRect(this.padding + this.labelPadding + 5, this.padding + 5, 172, 35);
        g2.setColor(this.lineColor);
        g2.drawString("RSSI of a single sweep [dBm]", this.padding + this.labelPadding + 10, this.padding + 15 + 5);
        g2.setColor(this.lineColorMaxVal);
        g2.drawString("max. RSSI [dBm]", this.padding + this.labelPadding + 10, this.padding + 30 + 5);
        g2.setColor(Color.BLACK);
        g2.drawString("Frequency [MHz]", this.getWidth() / 2, this.getHeight() - this.padding);
        for (int i2 = 0; i2 < this.numberYDivisions + 1; ++i2) {
            int y0;
            int x0 = this.padding + this.labelPadding;
            int x14 = this.pointWidth + this.padding + this.labelPadding;
            y1 = y0 = this.getHeight() - (i2 * (this.getHeight() - this.padding * 2 - this.labelPadding) / this.numberYDivisions + this.padding + this.labelPadding);
            if (this.rssiValues.size() > 0) {
                g2.setColor(this.gridColor);
                g2.drawLine(this.padding + this.labelPadding + 1 + this.pointWidth, y0, this.getWidth() - this.padding, y1);
                g2.setColor(Color.BLACK);
                String yLabel = -120.0 + (double)(10 * i2) + "";
                FontMetrics metrics = g2.getFontMetrics();
                int labelWidth = metrics.stringWidth(yLabel);
                g2.drawString(yLabel, x0 - labelWidth - 5, y0 + metrics.getHeight() / 2 - 3);
            }
            g2.drawLine(x0, y0, x14, y1);
        }
        Iterator<Double> itrFrequencies = this.frequencies.iterator();
        for (int i3 = 0; i3 < this.rssiValues.size(); ++i3) {
            int x0;
            double f = itrFrequencies.next();
            if (this.rssiValues.size() <= 1) continue;
            int x15 = x0 = i3 * (this.getWidth() - this.padding * 2 - this.labelPadding) / (this.rssiValues.size() - 1) + this.padding + this.labelPadding;
            int y0 = this.getHeight() - this.padding - this.labelPadding;
            int y14 = y0 - this.pointWidth;
            if (i3 % ((int)((double)this.rssiValues.size() / 20.0) + 1) != 0) continue;
            g2.setColor(this.gridColor);
            g2.drawLine(x0, this.getHeight() - this.padding - this.labelPadding - 1 - this.pointWidth, x15, this.padding);
            g2.setColor(Color.BLACK);
            String xLabel = Double.toString((double)Math.round(f / 1000000.0 * 100.0) / 100.0);
            FontMetrics metrics = g2.getFontMetrics();
            int labelWidth = metrics.stringWidth(xLabel);
            g2.drawString(xLabel, x0 - labelWidth / 2, y0 + metrics.getHeight() + 3);
            g2.drawLine(x0, y0, x15, y14);
        }
        g2.drawLine(this.padding + this.labelPadding, this.getHeight() - this.padding - this.labelPadding, this.padding + this.labelPadding, this.padding);
        g2.drawLine(this.padding + this.labelPadding, this.getHeight() - this.padding - this.labelPadding, this.getWidth() - this.padding, this.getHeight() - this.padding - this.labelPadding);
        Stroke oldStroke = g2.getStroke();
        g2.setColor(this.lineColor);
        for (i = 0; i < graphPoints.size() - 1; ++i) {
            x1 = ((Point)graphPoints.get((int)i)).x;
            y1 = ((Point)graphPoints.get((int)i)).y;
            int x2 = ((Point)graphPoints.get((int)(i + 1))).x;
            int y2 = ((Point)graphPoints.get((int)(i + 1))).y;
            g2.drawLine(x1, y1, x2, y2);
        }
        g2.setStroke(oldStroke);
        g2.setColor(this.lineColorMaxVal);
        for (i = 0; i < graphPointsMax.size() - 1; ++i) {
            x1 = ((Point)graphPointsMax.get((int)i)).x;
            y1 = ((Point)graphPointsMax.get((int)i)).y;
            int x2 = ((Point)graphPointsMax.get((int)(i + 1))).x;
            int y2 = ((Point)graphPointsMax.get((int)(i + 1))).y;
            g2.drawLine(x1, y1, x2, y2);
        }
    }

    private double getMaxScore() {
        double maxScore = -20.0;
        for (Byte score : this.rssiValues) {
            maxScore = Math.max(maxScore, (double)score.byteValue());
        }
        return maxScore;
    }

    public void createGraph() {
        BufferedImage bi = new BufferedImage(1280, 800, 2);
        Graphics2D g = bi.createGraphics();
        this.paintComponent(g);
        g.dispose();
        this.imageQueue.add(bi);
        this.imageQueue.poll();
    }

    public BufferedImage getGraph() {
        return this.imageQueue.peek();
    }
}

