/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.mode;

import at.mrdevelopment.esl.accesspoint.mode.AccessPointOperationMode;
import at.mrdevelopment.esl.accesspoint.mode.AccessPointThinMode;
import at.mrdevelopment.esl.accesspoint.mode.Location;

public class AccessPointMode {
    private AccessPointOperationMode operationMode;
    private AccessPointThinMode thinMode;
    private Location location;

    private AccessPointMode(boolean thinModeEnabled, AccessPointThinMode thinMode) {
        this.operationMode = thinModeEnabled ? AccessPointOperationMode.THIN : AccessPointOperationMode.THICK;
        this.thinMode = thinMode;
    }

    private AccessPointMode(AccessPointOperationMode operationMode, AccessPointThinMode thinMode, Location location) {
        this.operationMode = operationMode;
        this.thinMode = thinMode;
        this.location = location;
    }

    public AccessPointOperationMode getOperationMode() {
        return this.operationMode;
    }

    public AccessPointThinMode getThinMode() {
        return this.thinMode;
    }

    public boolean thinApEnabled() {
        return this.operationMode == AccessPointOperationMode.THIN;
    }

    public boolean isOnServer() {
        return this.location == Location.SERVER;
    }

    public static AccessPointMode createOnAccessPoint(boolean thinModeEnabled, AccessPointThinMode thinMode) {
        return AccessPointMode.create(thinModeEnabled, thinMode, Location.ACCESS_POINT);
    }

    public static AccessPointMode createOnServer(boolean thinModeEnabled, AccessPointThinMode thinMode) {
        return AccessPointMode.create(thinModeEnabled, thinMode, Location.SERVER);
    }

    private static AccessPointMode create(boolean thinModeEnabled, AccessPointThinMode thinMode, Location location) {
        return new AccessPointMode(thinModeEnabled ? AccessPointOperationMode.THIN : AccessPointOperationMode.THICK, thinMode, location);
    }
}

