/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.http;

import at.mrdevelopment.esl.accesspoint.serial.ChannelFilterBandwidth;
import at.mrdevelopment.esl.accesspoint.serial.SerialConfiguration;
import at.mrdevelopment.esl.admin.ConfigurationForm;
import at.mrdevelopment.toolkit.http.HttpFormParser;
import at.mrdevelopment.toolkit.xml.SerializeException;
import org.apache.http.HttpEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SerialConfigurationHtmlFormParser {
    public ConfigurationForm parseSerialConfigurationForm(HttpEntity body) throws SerializeException {
        try {
            HttpFormParser formParser = new HttpFormParser(body);
            ConfigurationForm serialForm = new ConfigurationForm("serial-form");
            serialForm.setValue("wiSpyEnabled", String.valueOf(formParser.getBooleanValue("wiSpyEnabled")));
            serialForm.setValue("startFrequency", formParser.getValue("startFrequency"));
            serialForm.setValue("endFrequency", formParser.getValue("endFrequency"));
            serialForm.setValue("numberOfSweeps", formParser.getValue("numberOfSweeps"));
            serialForm.setValue("channelFilterBandwidth", formParser.getValue("channelFilterBandwidth"));
            return serialForm;
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public ConfigurationForm updateValues(ConfigurationForm serialForm, SerialConfiguration serialConfiguration) {
        serialForm.setValue("wiSpyEnabled", String.valueOf(serialConfiguration.isWiSpyEnabled()));
        if (serialConfiguration.isWiSpyEnabled()) {
            serialForm.setValue("startFrequency", String.valueOf(serialConfiguration.getStartFrequency()));
            serialForm.setValue("endFrequency", String.valueOf(serialConfiguration.getEndFrequency()));
            serialForm.setValue("numberOfSweeps", String.valueOf(serialConfiguration.getNumberOfSweeps()));
            serialForm.setValue("channelFilterBandwidth", serialConfiguration.getFilterBandwidth().name());
        } else {
            serialForm.setValue("startFrequency", null);
            serialForm.setValue("endFrequency", null);
            serialForm.setValue("numberOfSweeps", null);
            serialForm.setValue("channelFilterBandwidth", null);
        }
        return serialForm;
    }

    public SerialConfiguration toSerialConfiguration(ConfigurationForm serialForm) {
        boolean wiSpyEnabled = Boolean.valueOf(serialForm.getValue("wiSpyEnabled"));
        if (wiSpyEnabled) {
            long startFrequency = Long.valueOf(serialForm.getValue("startFrequency"));
            long endFrequency = Long.valueOf(serialForm.getValue("endFrequency"));
            int numberOfSweeps = Integer.valueOf(serialForm.getValue("numberOfSweeps"));
            ChannelFilterBandwidth bandwidth = ChannelFilterBandwidth.valueOf(serialForm.getValue("channelFilterBandwidth").toUpperCase());
            return new SerialConfiguration(wiSpyEnabled, startFrequency, endFrequency, numberOfSweeps, bandwidth);
        }
        return new SerialConfiguration();
    }

    public Document toXML(Document document) {
        Element bandwidthListElement = document.createElement("ChannelFilterBandwidthList");
        for (ChannelFilterBandwidth bandwidth : ChannelFilterBandwidth.values()) {
            bandwidthListElement.appendChild(this.toXML(bandwidth, document));
        }
        document.getDocumentElement().appendChild(bandwidthListElement);
        return document;
    }

    private Element toXML(ChannelFilterBandwidth bandwidth, Document document) {
        Element bandwidthElement = document.createElement("ChannelFilterBandwidth");
        bandwidthElement.setAttribute("bandwidth", String.valueOf(bandwidth.getBandwidth()));
        bandwidthElement.setAttribute("name", bandwidth.name());
        return bandwidthElement;
    }
}

