/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.http;

import at.mrdevelopment.esl.accesspoint.AccessPoint;
import at.mrdevelopment.esl.accesspoint.AccessPointDataListener;
import at.mrdevelopment.esl.accesspoint.DiscoveredLabelsContentProducer;
import at.mrdevelopment.esl.accesspoint.RequestQueue;
import at.mrdevelopment.esl.accesspoint.request.AbortUpdateTaskRequest;
import at.mrdevelopment.esl.accesspoint.request.AddUpdateTasksRequest;
import at.mrdevelopment.esl.accesspoint.request.ClearRoamingTableRequest;
import at.mrdevelopment.esl.accesspoint.request.RemoveUpdateTaskRequest;
import at.mrdevelopment.esl.accesspoint.request.SetRoamingTableRequest;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.JoinStatus;
import at.mrdevelopment.esl.roaming.InternalRoamingTable;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.xml.sax.TaskIdSAXXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.HttpContentType;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.log.ComputationTimeLogger;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.http.entity.ContentProducer;
import org.w3c.dom.Document;

@Route(route="/service")
public class AccessPointWebserviceRequestHandler
implements WebserviceRequestHandler {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointWebserviceRequestHandler.class);
    private final AccessPoint accessPoint;
    private final RequestQueue requestQueue;
    private final TaskIdSAXXMLSerializer taskIdSerializer;
    private final AccessPointDataListener accessPointDataListener;
    private final String stylesheet;

    public AccessPointWebserviceRequestHandler(AccessPoint accessPoint, AccessPointDataListener accessPointDataListener, RequestQueue requestQueue, String stylesheet) throws InitializationException {
        this.accessPoint = accessPoint;
        this.accessPointDataListener = accessPointDataListener;
        this.requestQueue = requestQueue;
        this.taskIdSerializer = new TaskIdSAXXMLSerializer();
        this.stylesheet = stylesheet;
    }

    @Route(method=HttpRequestMethod.POST, route="tasks/add.xml")
    public void addTasks(WebserviceRequest request, WebserviceResponse response) throws SerializeException, IOException {
        logger.info("Handling request addTasks");
        ComputationTimeLogger timeLogger = new ComputationTimeLogger(logger).start();
        InputStream inputStream = request.getBody().getContent();
        List<ExternalUpdateTask> updateTasks = this.accessPointDataListener.parseUpdateTasks(inputStream);
        timeLogger.logTimeInfo("Time for parsing update tasks");
        timeLogger.start();
        this.accessPoint.prepareTaskImages(updateTasks);
        timeLogger.logTimeInfo("Time for preparing images");
        if (updateTasks.size() > 0) {
            this.requestQueue.addUpdateTaskPartionRequests(updateTasks, AddUpdateTasksRequest.class);
        }
        response.respondMessage(String.format("%d update tasks scheduled", updateTasks.size()));
    }

    @Route(method=HttpRequestMethod.POST, route="labels/assignment.xml")
    public void setRoamingTable(WebserviceRequest request, WebserviceResponse response) throws Exception {
        logger.info("Handling request setRoamingTable");
        ComputationTimeLogger timeLogger = new ComputationTimeLogger(logger).start();
        InputStream inputStream = request.getBody().getContent();
        String hostName = request.getRemoteHost().getHostAddress();
        String hostAddress = request.getRemoteHost().getHostAddress();
        InternalRoamingTable internalRoamingTable = this.accessPointDataListener.parseRoamingTable(inputStream, hostName, hostAddress);
        timeLogger.logTimeInfo("Time for parsing roaming table");
        this.requestQueue.addRequest(new SetRoamingTableRequest(internalRoamingTable));
        response.respondMessage("Roaming table accepted");
    }

    @Route(method=HttpRequestMethod.GET, route="tasks/all.xml")
    public void getAllTasks(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        logger.info("Handling request getAllTasks");
        Document document = this.accessPointDataListener.getAllUpdateTasksDocument();
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.GET, route="tasks/finished.xml")
    public void getFinishedTasks(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        logger.info("Handling request getFinishedTasks");
        Document document = this.accessPointDataListener.getFinishedUpdateTasksDocument();
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.GET, route="tasks/:key.xml", pattern="[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}")
    public void getTask(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        logger.info("Handling request getTask");
        UUID taskId = UUID.fromString(request.getUrlBaseName());
        Document document = this.accessPointDataListener.getUpdateTaskDocument(taskId);
        if (document != null) {
            response.respondDocument(document, request.isGzipEncodingAccepted());
        } else {
            response.respondFileNotFound(String.format("Task %s not found", taskId));
        }
    }

    @Route(method=HttpRequestMethod.GET, route="tasks/remove/all.xml")
    public void removeAllTasks(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        logger.info("Handling request removeAllTasks");
        List<ExternalUpdateTask> updateTasks = this.accessPointDataListener.getAllUpdateTasks();
        ArrayList<UUID> taskIds = new ArrayList<UUID>();
        for (ExternalUpdateTask updateTask : updateTasks) {
            taskIds.add(updateTask.getTaskId());
        }
        if (updateTasks.size() > 0) {
            this.requestQueue.addTaskIdPartionRequests(taskIds, RemoveUpdateTaskRequest.class);
        }
        logger.info("Scheduled %d tasks for removal", new Object[]{updateTasks.size()});
        response.respondMessage(String.format("Scheduled all %d tasks for removal", updateTasks.size()));
    }

    @Route(method=HttpRequestMethod.POST, route="tasks/remove.xml")
    public void removeTasks(WebserviceRequest request, WebserviceResponse response) throws SerializeException, IllegalStateException, IOException {
        logger.info("Handling request removeTasks");
        List taskIds = this.taskIdSerializer.parseXML(request.getBody().getContent());
        if (taskIds.size() > 0) {
            this.requestQueue.addTaskIdPartionRequests(taskIds, RemoveUpdateTaskRequest.class);
        }
        logger.info("Scheduled %d tasks for removal", new Object[]{taskIds.size()});
        response.respondMessage(String.format("Scheduled %d tasks for removal", taskIds.size()));
    }

    @Route(method=HttpRequestMethod.GET, route="tasks/remove/:key.xml", pattern="[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}")
    public void removeTask(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        logger.info("Handling request removeTask");
        UUID taskId = UUID.fromString(request.getUrlBaseName());
        this.requestQueue.addRequest(new RemoveUpdateTaskRequest(Collections.singleton(taskId)));
        response.respondMessage(String.format("Scheduled task %s for removal", taskId));
    }

    @Route(method=HttpRequestMethod.GET, route="tasks/abort/all.xml")
    public void abortAllTasks(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        logger.info("Handling request abortAllTasks");
        List<ExternalUpdateTask> updateTasks = this.accessPointDataListener.getAllUpdateTasks();
        ArrayList<UUID> taskIds = new ArrayList<UUID>();
        for (ExternalUpdateTask updateTask : updateTasks) {
            taskIds.add(updateTask.getTaskId());
        }
        if (taskIds.size() > 0) {
            this.requestQueue.addTaskIdPartionRequests(taskIds, AbortUpdateTaskRequest.class);
        }
        logger.info("Scheduled %d tasks for aborting", new Object[]{updateTasks.size()});
        response.respondMessage(String.format("Scheduled all %d tasks for aborting", taskIds.size()));
    }

    @Route(method=HttpRequestMethod.POST, route="tasks/abort.xml")
    public void abortTasks(WebserviceRequest request, WebserviceResponse response) throws SerializeException, IllegalStateException, IOException {
        logger.info("Handling request abortTasks");
        List taskIds = this.taskIdSerializer.parseXML(request.getBody().getContent());
        if (taskIds.size() > 0) {
            this.requestQueue.addTaskIdPartionRequests(taskIds, AbortUpdateTaskRequest.class);
        }
        logger.info("Scheduled %d tasks for aborting", new Object[]{taskIds.size()});
        response.respondMessage(String.format("Scheduled %d tasks for aborting", taskIds.size()));
    }

    @Route(method=HttpRequestMethod.GET, route="tasks/abort/:key.xml", pattern="[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}")
    public void abortTask(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        logger.info("Handling request abortTask");
        UUID taskId = UUID.fromString(request.getUrlBaseName());
        this.requestQueue.addRequest(new AbortUpdateTaskRequest(Collections.singleton(taskId)));
        response.respondMessage(String.format("Scheduled task %s for aborting", taskId));
    }

    @Route(method=HttpRequestMethod.GET, route="labels/discovered.xml")
    public void getJoinRequests(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        logger.info("Handling request getJoinRequests");
        response.respondContentProducer((ContentProducer)new DiscoveredLabelsContentProducer(this.accessPointDataListener.getAllJoinRequests(), this.accessPointDataListener.isAcceptAllLabels(), this.stylesheet), HttpContentType.XML, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.GET, route="labels/joinstatus/:key.xml", pattern="[a-z]+")
    public void getJoinRequestsWithStatus(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        logger.info("Handling request getJoinRequestsWithStatus");
        JoinStatus joinStatus = JoinStatus.valueOf((String)request.getUrlBaseName().toUpperCase());
        Document document = this.accessPointDataListener.getJoinRequestsWithJoinStatusDocument(joinStatus);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.GET, route="labels/accepted/withinseconds/:key.xml", pattern="[0-9]+")
    public void getAcceptedJoinRequestsWithinSeconds(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        logger.info("Handling request getAcceptedJoinRequestsWithinSeconds");
        int seconds = Integer.parseInt(request.getUrlBaseName());
        Document document = this.accessPointDataListener.getJoinRequestsWithJoinStatusDocument(JoinStatus.ACCEPTED, seconds);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.GET, route="labels/events.xml")
    public void getLabelEvents(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        logger.info("Handling request getAcceptedJoinRequestsWithinSeconds");
        Document document = this.accessPointDataListener.getLabelEventsDocument();
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.GET, route="labels/assigned.xml")
    public void getAssignedLabels(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        logger.info("Handling request getAssignedLabels");
        Document document = this.accessPointDataListener.getAssignedLabelsDocument();
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.GET, route="labels/online.xml")
    public void getOnlineLabels(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        logger.info("Handling request getOnlineLabels");
        Document document = this.accessPointDataListener.getLabelsWithConnectionStatusDocument(ConnectionStatus.ONLINE);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.GET, route="labels/offline.xml")
    public void getOfflineLabels(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        logger.info("Handling request getOfflineLabels");
        Document document = this.accessPointDataListener.getLabelsWithConnectionStatusDocument(ConnectionStatus.OFFLINE);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.GET, route="labels/lastseenwithinseconds/:key.xml", pattern="[0-9]+")
    public void getLabelsSeenWithinSeconds(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        logger.info("Handling request getLabelsSeenWithinSeconds");
        int seconds = Integer.parseInt(request.getUrlBaseName());
        Document document = this.accessPointDataListener.getLabelsLastSeenWithinSecondsDocument(seconds);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.GET, route="labels/registered.xml")
    public void getRegisteredLabels(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        logger.info("Handling request getRegisteredLabels");
        response.respondContentProducer(this.accessPointDataListener.getRegisteredLabelsContentProducer(this.stylesheet), HttpContentType.XML, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.GET, route="roaming/remove.xml")
    public void removeRoamingTable(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        logger.info("Handling request removeRoamingTable");
        this.requestQueue.addRequest(new ClearRoamingTableRequest());
        response.respondMessage("Roaming table removed");
    }

    @Route(method=HttpRequestMethod.GET, route="labels/:key.xml", pattern="[0-9a-fA-F]{8}")
    public void getLabelDetails(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        logger.info("Handling request getLabelDetails");
        Address labelAddress = Address.fromString((String)request.getUrlBaseName());
        Document document = this.accessPointDataListener.getLabelDocument(labelAddress);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

