/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.http;

import at.mrdevelopment.esl.accesspoint.http.SerialConfigurationHtmlFormParser;
import at.mrdevelopment.esl.accesspoint.serial.SerialConfigurationManager;
import at.mrdevelopment.esl.admin.ConfigurationForm;
import at.mrdevelopment.esl.admin.ConfigurationValidator;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Restrict;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import java.awt.image.BufferedImage;
import org.apache.http.HttpEntity;
import org.w3c.dom.Document;

@Route(route="/service/serial")
public class AccessPointSerialRequestHandler
implements WebserviceRequestHandler {
    private final SerialConfigurationManager serialConfigurationManager;
    private final SerialConfigurationHtmlFormParser formParser;
    private final ConfigurationValidator validator;

    public AccessPointSerialRequestHandler(SerialConfigurationManager serialConfigurationManager) throws InitializationException {
        this.serialConfigurationManager = serialConfigurationManager;
        this.formParser = new SerialConfigurationHtmlFormParser();
        this.validator = new ConfigurationValidator();
    }

    @Route(method=HttpRequestMethod.GET, route="serialConfiguration.xml")
    public void getSerialConfiguration(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ConfigurationForm serialForm = new ConfigurationForm("serial-form");
        serialForm = this.formParser.updateValues(serialForm, this.serialConfigurationManager.getSerialConfiguration());
        Document document = this.formParser.toXML(serialForm.toXML());
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="serialConfiguration.html")
    public void setSerialConfiguration(WebserviceRequest request, WebserviceResponse response) throws Exception {
        HttpEntity body = request.getBody();
        ConfigurationForm serialForm = this.formParser.parseSerialConfigurationForm(body);
        if (this.validator.validate(serialForm)) {
            if (this.serialConfigurationManager.setSerialConfiguration(this.formParser.toSerialConfiguration(serialForm))) {
                response.respondMessage("Serial settings updated.");
            } else {
                Document document = this.formParser.toXML(serialForm.toXML());
                response.respondDocument(document, request.isGzipEncodingAccepted());
            }
        } else {
            Document document = this.formParser.toXML(serialForm.toXML());
            response.respondDocument(document, request.isGzipEncodingAccepted());
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="result.png")
    public void getWiSpyResult(WebserviceRequest request, WebserviceResponse response) throws Exception {
        if (this.serialConfigurationManager.getSerialConfiguration().isWiSpyEnabled()) {
            BufferedImage resultImage = this.serialConfigurationManager.getImage();
            if (resultImage != null) {
                response.respondImage(resultImage);
            } else {
                response.respondMessage("Unable to receive result image", 500);
            }
        } else {
            response.respondMessage("WiSpy is not enabled");
        }
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

