/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.http;

import at.mrdevelopment.esl.accesspoint.AccessPoint;
import at.mrdevelopment.esl.accesspoint.AccessPointCommonDataListener;
import at.mrdevelopment.esl.accesspoint.AccessPointDataListener;
import at.mrdevelopment.esl.accesspoint.AccessPointRuntimeConfiguration;
import at.mrdevelopment.esl.accesspoint.RequestQueue;
import at.mrdevelopment.esl.accesspoint.http.AccessPointAdministrationWebserviceRequestHandler;
import at.mrdevelopment.esl.accesspoint.http.AccessPointOperationMetricsRequestHandler;
import at.mrdevelopment.esl.accesspoint.http.AccessPointPasswordProvider;
import at.mrdevelopment.esl.accesspoint.http.AccessPointSerialRequestHandler;
import at.mrdevelopment.esl.accesspoint.http.AccessPointStatusWSRequestHandler;
import at.mrdevelopment.esl.accesspoint.http.AccessPointStyleSheets;
import at.mrdevelopment.esl.accesspoint.http.AccessPointUtilizationRequestHandler;
import at.mrdevelopment.esl.accesspoint.http.AccessPointWebserviceRequestHandler;
import at.mrdevelopment.esl.accesspoint.mode.AccessPointMode;
import at.mrdevelopment.esl.accesspoint.serial.SerialConfigurationManager;
import at.mrdevelopment.esl.accesspoint.tcp.InfoPacketHolder;
import at.mrdevelopment.esl.admin.AdministrationStaticFileWebserviceRequestHandler;
import at.mrdevelopment.esl.admin.BackendWebserviceRequestHandler;
import at.mrdevelopment.esl.admin.platform.AccessPointSystemAttributes;
import at.mrdevelopment.esl.admin.platform.SystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.control.AccessPointBackendControl;
import at.mrdevelopment.esl.admin.platform.config.control.BackendControl;
import at.mrdevelopment.esl.admin.platform.config.manager.AccessPointConfigurationManager;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.core.accesspoint.AccessPointTypeMapping;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Authenticator;
import at.mrdevelopment.toolkit.authentication.HashAuthenticator;
import at.mrdevelopment.toolkit.authentication.PasswordProvider;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.http.Authentication;
import at.mrdevelopment.toolkit.http.BasicAuthentication;
import at.mrdevelopment.toolkit.http.BasicHttpRequestHandler;
import at.mrdevelopment.toolkit.http.BasicHttpServer;
import at.mrdevelopment.toolkit.http.HttpResource;
import at.mrdevelopment.toolkit.http.NoAuthentication;
import at.mrdevelopment.toolkit.http.StaticFileHttpRequestHandler;
import at.mrdevelopment.toolkit.http.StaticFileHttpResource;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.ExceptionXMLSerializer;

public class AccessPointHttpServer
extends BasicHttpServer {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointHttpServer.class);
    private static final String XSL = "/xsl/accesspoint.xsl";
    private static final String THIN_SERVER_XSL = "/xsl/thin-server-accesspoint.xsl";
    private static final String THIN_XSL = "/xsl/thin-accesspoint.xsl";
    private static final String DEFAULT_ADMINISTRATION_XSL = "/xsl/ap-administration.xsl";
    private static final String THIN_AP_ADMINISTRATION_XSL = "/xsl/thinap-administration.xsl";
    private static final String THIN_AP_INDEX = "thin-ap-index.xml";
    private static final String THIN_SERVER_AP_INDEX = "thin-server-ap-index.xml";
    private static final String DEFAULT_INDEX = "ap-index.xml";
    private final ExceptionXMLSerializer exceptionXMLSerializer = new ExceptionXMLSerializer();
    private final Authentication configAuthentication;
    private final Authentication serviceAuthentication;

    public AccessPointHttpServer(AccessPoint accessPoint, AccessPointMode apMode, AccessPointCommonDataListener accessPointDataListener, RequestQueue requestQueue, AccessPointBackendControl backendControl, AccessPointConfigurationManager configurationManager, AccessPointSystemAttributes systemAttributes, AccessPointRuntimeConfiguration runtimeConfiguration, SerialConfigurationManager serialConfigurationManager) throws InitializationException {
        this(accessPoint, apMode, accessPointDataListener, requestQueue, backendControl, configurationManager, systemAttributes, runtimeConfiguration, serialConfigurationManager, null, false);
    }

    public AccessPointHttpServer(AccessPoint accessPoint, AccessPointMode apMode, AccessPointCommonDataListener accessPointDataListener, RequestQueue requestQueue, AccessPointBackendControl backendControl, AccessPointConfigurationManager configurationManager, AccessPointSystemAttributes systemAttributes, AccessPointRuntimeConfiguration runtimeConfiguration, SerialConfigurationManager serialConfigurationManager, InfoPacketHolder infoPacketHodler, boolean isProtectionLevelHigh) throws InitializationException {
        HashAuthenticator authenticator = new HashAuthenticator((PasswordProvider)new AccessPointPasswordProvider(systemAttributes), Role.ADMIN);
        this.configAuthentication = new BasicAuthentication((Authenticator)authenticator, "imagotag Access Point");
        this.serviceAuthentication = isProtectionLevelHigh ? new BasicAuthentication((Authenticator)authenticator, "imagotag Access Point") : new NoAuthentication(Role.USER);
        this.initializeRequestHandlers(accessPoint, apMode, accessPointDataListener, requestQueue, backendControl, configurationManager, systemAttributes, runtimeConfiguration, serialConfigurationManager, infoPacketHodler);
    }

    private void initializeRequestHandlers(AccessPoint accessPoint, AccessPointMode apMode, AccessPointCommonDataListener accessPointDataListener, RequestQueue requestQueue, AccessPointBackendControl backendControl, AccessPointConfigurationManager configurationManager, AccessPointSystemAttributes systemAttributes, AccessPointRuntimeConfiguration runtimeConfiguration, SerialConfigurationManager serialConfigurationManager, InfoPacketHolder infoPacketHolder) throws InitializationException {
        AccessPointType apType = AccessPointTypeMapping.getType((int)systemAttributes.getId());
        AccessPointStyleSheets styleSheets = this.getStyleSheets(accessPoint, apType, apMode);
        if (!apMode.isOnServer()) {
            this.register(new AccessPointOperationMetricsRequestHandler(infoPacketHolder), styleSheets.getXsl(), this.serviceAuthentication);
            if (!apMode.thinApEnabled()) {
                this.register(new AccessPointWebserviceRequestHandler(accessPoint, (AccessPointDataListener)accessPointDataListener, requestQueue, styleSheets.getXsl()), styleSheets.getXsl(), this.serviceAuthentication);
                this.register(new AccessPointUtilizationRequestHandler(accessPoint), styleSheets.getXsl(), this.serviceAuthentication);
            }
        } else {
            this.register(new AccessPointWebserviceRequestHandler(accessPoint, (AccessPointDataListener)accessPointDataListener, requestQueue, styleSheets.getXsl()), styleSheets.getXsl(), this.serviceAuthentication);
            this.register(new AccessPointUtilizationRequestHandler(accessPoint), styleSheets.getXsl(), this.serviceAuthentication);
        }
        this.register(new AccessPointStatusWSRequestHandler(accessPointDataListener), styleSheets.getXsl(), this.serviceAuthentication);
        this.register((WebserviceRequestHandler)new AdministrationStaticFileWebserviceRequestHandler((SystemAttributes)systemAttributes), styleSheets.getAdminXsl(), this.configAuthentication);
        if (apType == AccessPointType.IMAGOTAG || apType == AccessPointType.USB_AP) {
            this.register((WebserviceRequestHandler)new BackendWebserviceRequestHandler((BackendControl)backendControl), styleSheets.getXsl(), this.serviceAuthentication);
            this.register((WebserviceRequestHandler)new AccessPointAdministrationWebserviceRequestHandler(backendControl, configurationManager, systemAttributes, runtimeConfiguration), styleSheets.getAdminXsl(), this.configAuthentication);
        }
        if (serialConfigurationManager != null) {
            this.register(new AccessPointSerialRequestHandler(serialConfigurationManager), styleSheets.getAdminXsl(), this.configAuthentication);
        }
        this.register((WebserviceRequestHandler)new StaticFileHttpRequestHandler("/webroot", (HttpResource)new StaticFileHttpResource(styleSheets.getIndexFile(), "/webroot")), styleSheets.getXsl(), this.serviceAuthentication);
    }

    private AccessPointStyleSheets getStyleSheets(AccessPoint accessPoint, AccessPointType apType, AccessPointMode apMode) {
        String xsl = null;
        String adminXsl = null;
        String indexFile = null;
        xsl = apMode.isOnServer() ? THIN_SERVER_XSL : (apMode.thinApEnabled() ? THIN_XSL : XSL);
        if (apType == AccessPointType.IMAGOTAG) {
            String string = adminXsl = apMode.isOnServer() ? THIN_AP_ADMINISTRATION_XSL : DEFAULT_ADMINISTRATION_XSL;
            indexFile = apMode.isOnServer() ? THIN_SERVER_AP_INDEX : (apMode.thinApEnabled() ? THIN_AP_INDEX : DEFAULT_INDEX);
        } else if (apType == AccessPointType.USB_AP) {
            adminXsl = THIN_AP_ADMINISTRATION_XSL;
            indexFile = THIN_SERVER_AP_INDEX;
        } else {
            adminXsl = THIN_AP_ADMINISTRATION_XSL;
            indexFile = THIN_SERVER_AP_INDEX;
        }
        return new AccessPointStyleSheets(xsl, adminXsl, indexFile);
    }

    public void register(WebserviceRequestHandler handler, String styleSheet, Authentication authentication) throws InitializationException {
        super.register(new BasicHttpRequestHandler(handler, styleSheet, authentication, this.exceptionXMLSerializer));
    }
}

