/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.http;

import at.mrdevelopment.esl.accesspoint.AccessPointRuntimeConfiguration;
import at.mrdevelopment.esl.admin.AccessPointConfigurationXMLSerializer;
import at.mrdevelopment.esl.admin.AdministrationWebserviceRequestHandler;
import at.mrdevelopment.esl.admin.ConfigurationForm;
import at.mrdevelopment.esl.admin.platform.AccessPointSystemAttributes;
import at.mrdevelopment.esl.admin.platform.BackendTaskStatus;
import at.mrdevelopment.esl.admin.platform.SystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.RuntimeConfiguration;
import at.mrdevelopment.esl.admin.platform.config.SSLConfiguration;
import at.mrdevelopment.esl.admin.platform.config.WebserviceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.AccessPointConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.AutoConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.BroadcastConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.ThinAPConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.WirelessConfiguration;
import at.mrdevelopment.esl.admin.platform.config.control.AccessPointBackendControl;
import at.mrdevelopment.esl.admin.platform.config.control.BackendControl;
import at.mrdevelopment.esl.admin.platform.config.manager.AccessPointConfigurationManager;
import at.mrdevelopment.esl.admin.platform.config.manager.ConfigurationManager;
import at.mrdevelopment.esl.admin.platform.config.network.AbstractNetworkConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkConfiguration;
import at.mrdevelopment.esl.admin.platform.upload.AccessPointSoftwareUploadExecutor;
import at.mrdevelopment.esl.msp.MSPConfiguration;
import at.mrdevelopment.esl.xml.AccessPointTLSCertificateXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.HttpContentType;
import at.mrdevelopment.toolkit.http.HttpFormParser;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.MultipartFileParser;
import at.mrdevelopment.toolkit.http.Restrict;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.log.LogList;
import at.mrdevelopment.toolkit.log.MemoryLogger;
import at.mrdevelopment.toolkit.security.Password;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.File;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.log4j.Level;
import org.w3c.dom.Document;

@Route(route="/service/config")
public class AccessPointAdministrationWebserviceRequestHandler
extends AdministrationWebserviceRequestHandler<AccessPointConfigurationManager, AccessPointBackendControl, AccessPointSystemAttributes> {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointAdministrationWebserviceRequestHandler.class);
    private final AccessPointRuntimeConfiguration runtimeConfiguration;
    private final AccessPointConfigurationXMLSerializer xmlSerializer;
    private final AccessPointSoftwareUploadExecutor firmwareUploadExecutor;
    private final AccessPointTLSCertificateXMLSerializer tlsCertificateSerializer;
    private static final String UPLOADS_FOLDER = "/opt/esl/backend/uploads";

    public AccessPointAdministrationWebserviceRequestHandler(AccessPointBackendControl backendControl, AccessPointConfigurationManager configurationManager, AccessPointSystemAttributes systemAttributes, AccessPointRuntimeConfiguration runtimeConfiguration) throws InitializationException {
        super((BackendControl)backendControl, (ConfigurationManager)configurationManager, (SystemAttributes)systemAttributes, (RuntimeConfiguration)runtimeConfiguration);
        this.runtimeConfiguration = runtimeConfiguration;
        this.xmlSerializer = new AccessPointConfigurationXMLSerializer();
        this.firmwareUploadExecutor = new AccessPointSoftwareUploadExecutor(backendControl);
        this.tlsCertificateSerializer = new AccessPointTLSCertificateXMLSerializer();
    }

    @Route(method=HttpRequestMethod.GET, route="password.xml")
    public void changePassword(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        response.respondDocument(this.xmlSerializer.createChangePasswordXML(), request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.POST, route="password.html")
    public void setPassword(WebserviceRequest request, WebserviceResponse response) throws Exception {
        HttpFormParser formParser = new HttpFormParser(request.getBody());
        String oldPassword = formParser.getValue("oldPassword");
        String newPassword = formParser.getValue("newPassword");
        String newPasswordConfirm = formParser.getValue("newPasswordConfirm");
        if (!(oldPassword == null || oldPassword.isEmpty() || newPassword == null || newPassword.isEmpty() || newPasswordConfirm == null || newPasswordConfirm.isEmpty())) {
            if (!((AccessPointSystemAttributes)this.systemAttributes).getPassword().verify(oldPassword)) {
                response.respondMessage("Wrong password.", 401);
            } else if (!newPassword.equals(newPasswordConfirm)) {
                response.respondMessage("Password confirmation does not match new password.", 400);
            } else if (oldPassword.equals(newPassword)) {
                response.respondMessage("Old and new password have to be different.", 400);
            } else {
                ((AccessPointSystemAttributes)this.systemAttributes).setPassword(Password.createFromPlainPassword((String)newPassword));
                response.respondMessage("Password changed.");
            }
        } else {
            response.respondMessage("Incomplete input.", 400);
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="wireless.xml")
    public void getWirelessSettings(WebserviceRequest request, WebserviceResponse response) throws Exception {
        WirelessConfiguration wirelessConfiguration = ((AccessPointConfigurationManager)this.configurationManager).getWirelessConfiguration();
        ConfigurationForm transmissionForm = new ConfigurationForm(wirelessConfiguration, ((AccessPointConfigurationManager)this.configurationManager).getAutoConfiguration().isEnabled().booleanValue());
        Document document = transmissionForm.toXML();
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="wireless.html")
    public void setWirelessSettings(WebserviceRequest request, WebserviceResponse response) throws Exception {
        HttpEntity body = request.getBody();
        ConfigurationForm transmissionForm = this.htmlFormParser.parseTransmissionConfigurationForm(body, ((AccessPointConfigurationManager)this.configurationManager).getAutoConfiguration().isEnabled().booleanValue());
        if (this.validator.validate(transmissionForm)) {
            if (((AccessPointConfigurationManager)this.configurationManager).setWirelessConfiguration(transmissionForm.toWirelessConfiguration())) {
                response.respondMessage("Wireless settings updated.");
            } else {
                Document document = transmissionForm.toXML();
                response.respondDocument(document, request.isGzipEncodingAccepted());
            }
        } else {
            Document document = transmissionForm.toXML();
            response.respondDocument(document, request.isGzipEncodingAccepted());
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="outputPower.xml")
    public void getRfPowerSetting(WebserviceRequest request, WebserviceResponse response) throws Exception {
        WirelessConfiguration wirelessConfiguration = ((AccessPointConfigurationManager)this.configurationManager).getWirelessConfiguration();
        ConfigurationForm rfPowerForm = new ConfigurationForm(wirelessConfiguration.getRadioOutputPowerLevel(), ((AccessPointConfigurationManager)this.configurationManager).getAutoConfiguration().isEnabled().booleanValue());
        Document document = rfPowerForm.toXML(wirelessConfiguration.getMaxRadioOutputPowerLevel());
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="outputPower.html")
    public void setRfPowerSEtting(WebserviceRequest request, WebserviceResponse response) throws Exception {
        HttpEntity body = request.getBody();
        ConfigurationForm rfPowerForm = this.htmlFormParser.parseOutputPowerConfigurationForm(body, ((AccessPointConfigurationManager)this.configurationManager).getAutoConfiguration().isEnabled().booleanValue());
        if (this.validator.validate(rfPowerForm)) {
            if (((AccessPointConfigurationManager)this.configurationManager).setOutputPowerConfiguration(rfPowerForm.toRfPowerSetting())) {
                response.respondMessage("Output power settings updated.");
            } else {
                Document document = rfPowerForm.toXML(((AccessPointConfigurationManager)this.configurationManager).getWirelessConfiguration().getMaxRadioOutputPowerLevel());
                response.respondDocument(document, request.isGzipEncodingAccepted());
            }
        } else {
            Document document = rfPowerForm.toXML(((AccessPointConfigurationManager)this.configurationManager).getWirelessConfiguration().getMaxRadioOutputPowerLevel());
            response.respondDocument(document, request.isGzipEncodingAccepted());
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="network.xml")
    public void getNetworkSettings(WebserviceRequest request, WebserviceResponse response) throws Exception {
        NetworkConfiguration networkConfiguration = ((AccessPointConfigurationManager)this.configurationManager).getNetworkConfiguration();
        Document document = new ConfigurationForm(networkConfiguration, ((AccessPointConfigurationManager)this.configurationManager).getAutoConfiguration().isEnabled().booleanValue()).toXML();
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="network.html")
    public void setNetworkSettings(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ConfigurationForm networkForm = this.htmlFormParser.parseNetworkInfoConfigurationForm(request.getBody(), false);
        if (this.validator.validate(networkForm)) {
            if (((AccessPointConfigurationManager)this.configurationManager).setNetworkConfiguration((AbstractNetworkConfiguration)networkForm.toNetworkConfiguration())) {
                response.respondMessage("Network settings updated. Restarting network service...");
            } else {
                Document document = networkForm.toXML();
                response.respondDocument(document, request.isGzipEncodingAccepted());
            }
        } else {
            Document document = networkForm.toXML();
            response.respondDocument(document, request.isGzipEncodingAccepted());
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="communicationDaemon.xml")
    public void getCommunicationDaemon(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ThinAPConfiguration thinAPConfiguration = ((AccessPointConfigurationManager)this.configurationManager).getThinAPConfiguration();
        Document document = new ConfigurationForm(((AccessPointSystemAttributes)this.systemAttributes).getDeviceMode(), thinAPConfiguration).toXML();
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="communicationDaemon.html")
    public void setCommunicationDaemon(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ConfigurationForm communicationDaemonForm = this.htmlFormParser.parseCommunicationDaemonConfigurationForm(request.getBody());
        if (this.validator.validate(communicationDaemonForm)) {
            ThinAPConfiguration newConfig = communicationDaemonForm.toThinAPConfiguration(((AccessPointConfigurationManager)this.configurationManager).getThinAPConfiguration());
            ThinAPConfiguration.Difference diff = newConfig.getDifferenceTo(((AccessPointConfigurationManager)this.configurationManager).getThinAPConfiguration());
            if (diff.isDifferent()) {
                ((AccessPointConfigurationManager)this.configurationManager).setThinAPConfiguration(newConfig);
                String responseMessage = "";
                if (diff.isConnectionModeDifferent() || diff.isTLSDifferent() || diff.isTLSStrictVerificationDifferent()) {
                    ((AccessPointBackendControl)this.backendControl).initCreateESLEnvironmentFile();
                    ((AccessPointBackendControl)this.backendControl).initCommunicationDaemonRestart();
                    responseMessage = responseMessage + "Connection mode updated. Communication daemon restart initialized. ";
                }
                if (diff.isThinModeDifferent()) {
                    responseMessage = responseMessage + "ThinAP mode updated. Service restart initialized.";
                    response.respondMessage(responseMessage);
                    ((AccessPointBackendControl)this.backendControl).initServiceRestart();
                } else {
                    response.respondMessage(responseMessage.isEmpty() ? "Communication daemon settings updated" : responseMessage);
                }
            } else {
                response.respondMessage("Communication Daemon settings unchanged!");
            }
        } else {
            response.respondMessage("Communication Daemon settings unchanged, could not validate form!");
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="msp.xml")
    public void getMSPSettings(WebserviceRequest request, WebserviceResponse response) throws Exception {
        MSPConfiguration mspConfiguration = ((AccessPointConfigurationManager)this.configurationManager).getMspConfiguration();
        Document document = new ConfigurationForm(mspConfiguration, ((AccessPointConfigurationManager)this.configurationManager).getAutoConfiguration().isEnabled().booleanValue()).toXML();
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="msp.html")
    public void setMSPSettings(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ConfigurationForm mspForm = this.htmlFormParser.parseMSPConfigurationForm(request.getBody(), ((AccessPointConfigurationManager)this.configurationManager).getAutoConfiguration().isEnabled().booleanValue());
        if (this.validator.validate(mspForm)) {
            if (((AccessPointConfigurationManager)this.configurationManager).setMspConfiguration(mspForm.toMSPConfiguration())) {
                response.respondMessage("MSP settings updated.");
            } else {
                Document document = mspForm.toXML();
                response.respondDocument(document, request.isGzipEncodingAccepted());
            }
        } else {
            Document document = mspForm.toXML();
            response.respondDocument(document, request.isGzipEncodingAccepted());
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="autoConfig.xml")
    public void getAutoConfigSettings(WebserviceRequest request, WebserviceResponse response) throws Exception {
        boolean autoConfig = ((AccessPointConfigurationManager)this.configurationManager).getAutoConfiguration().isEnabled();
        Document document = new ConfigurationForm(((AccessPointSystemAttributes)this.systemAttributes).getDeviceMode(), autoConfig).toXML();
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="autoConfig.html")
    public void setAutoConfigSettings(WebserviceRequest request, WebserviceResponse response) throws Exception {
        HttpFormParser formParser = new HttpFormParser(request.getBody());
        boolean autoConfigEnabled = formParser.getBooleanValue("autoConfig");
        if (((AccessPointConfigurationManager)this.configurationManager).setAutoConfiguration(new AutoConfiguration(autoConfigEnabled))) {
            response.respondMessage("Centralized configuration settings updated.");
        } else {
            this.getAutoConfigSettings(request, response);
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="broadcast.xml")
    public void getBroadcastSettings(WebserviceRequest request, WebserviceResponse response) throws Exception {
        BroadcastConfiguration broadcastConfiguration = ((AccessPointConfigurationManager)this.configurationManager).getBroadcastConfiguration();
        Document document = new ConfigurationForm(broadcastConfiguration, ((AccessPointConfigurationManager)this.configurationManager).getAutoConfiguration().isEnabled().booleanValue()).toXML();
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="broadcast.html")
    public void setBroadcastSettings(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ConfigurationForm broadcastForm = this.htmlFormParser.parseBroadcastConfigurationForm(request.getBody(), ((AccessPointConfigurationManager)this.configurationManager).getAutoConfiguration().isEnabled().booleanValue());
        if (this.validator.validate(broadcastForm)) {
            if (((AccessPointConfigurationManager)this.configurationManager).setBroadcastConfiguration(broadcastForm.toBroadcastConfiguration())) {
                response.respondMessage("Broadcast settings updated.");
            } else {
                Document document = broadcastForm.toXML();
                response.respondDocument(document, request.isGzipEncodingAccepted());
            }
        } else {
            Document document = broadcastForm.toXML();
            response.respondDocument(document, request.isGzipEncodingAccepted());
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="webservice.xml")
    public void getWebserviceConfiguration(WebserviceRequest request, WebserviceResponse response) throws Exception {
        WebserviceConfiguration webserviceConfiguration = ((AccessPointConfigurationManager)this.configurationManager).getWebserviceConfiguration();
        Document document = new ConfigurationForm(((AccessPointSystemAttributes)this.systemAttributes).getDeviceMode(), webserviceConfiguration, this.runtimeConfiguration.getPort()).toXML();
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="webservice.html")
    public void setWebserviceConfiguration(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ConfigurationForm webserviceForm = this.htmlFormParser.parseWebserviceConfiguration(request.getBody());
        if (((AccessPointConfigurationManager)this.configurationManager).setWebserviceConfiguration(webserviceForm.toWebserviceConfiguration())) {
            response.respondMessage("Webservice settings updated. Restarting service...");
        } else {
            Document document = webserviceForm.toXML();
            response.respondDocument(document, request.isGzipEncodingAccepted());
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="firmware/upload.html")
    public void handleFirmwareUpload(WebserviceRequest request, WebserviceResponse response) throws Exception {
        HttpEntity body = request.getBody();
        if (body.getContentType().getValue().contains(HttpContentType.FORM_MULTIPART.getValue())) {
            MultipartFileParser parser = new MultipartFileParser();
            try {
                File file = parser.writeFileFromStream(body, UPLOADS_FOLDER);
                this.firmwareUploadExecutor.processUploadedFile(file);
                response.respondMessage("Firmware upload successful. Starting firmware update...");
            }
            catch (Exception exc) {
                logger.logException((Throwable)exc);
                response.respondMessage(String.format("Firmware upload failed.", new Object[0]), 400);
            }
        } else {
            response.respondMessage("Invalid content type.", 400);
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="all.xml")
    public void setConfiguration(WebserviceRequest request, WebserviceResponse response) throws Exception {
        if (((AccessPointConfigurationManager)this.configurationManager).setAccessPointConfiguration(this.xmlSerializer.parseXML(request.getBody().getContent(), ((AccessPointConfigurationManager)this.configurationManager).getThinAPConfiguration()))) {
            response.respondMessage("Configuration updated.");
        } else {
            response.respondMessage("Configuration unchanged.");
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="configuration.xml")
    public void getConfiguration(WebserviceRequest request, WebserviceResponse response) throws Exception {
        AccessPointConfiguration accessPointConfiguration = (AccessPointConfiguration)((AccessPointConfigurationManager)this.configurationManager).getPlatformConfiguration();
        Document document = this.xmlSerializer.toXML(accessPointConfiguration);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="system/viewLog.xml")
    public void getLogging(WebserviceRequest request, WebserviceResponse response) throws Exception {
        if (MemoryLogger.isEnabled()) {
            List logList = LogList.getInstance().filterByLevel(Level.DEBUG);
            Document document = LogList.toXML((List)logList, (XMLToolkit)this.xmlToolkit);
            response.respondDocument(document, request.isGzipEncodingAccepted());
        } else {
            response.respondMessage("Logging disabled.");
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="sendBroadcast.xml")
    public void sendBroadcast(WebserviceRequest request, WebserviceResponse response) throws Exception {
        this.runtimeConfiguration.forceBroadcast();
        response.respondMessage("Discovery broadcast message sent.");
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="identifyDevice.xml")
    public void identifyDevice(WebserviceRequest request, WebserviceResponse response) throws Exception {
        this.runtimeConfiguration.enableIdentifyMode();
        response.respondMessage(String.format("Identify device mode enabled for %d minutes. Status LED will flash green.", 5));
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="ssl.xml")
    public void getSSLConfiguration(WebserviceRequest request, WebserviceResponse response) throws Exception {
        SSLConfiguration sslConfiguration = ((AccessPointConfigurationManager)this.configurationManager).getSSLConfiguration();
        Document document = new ConfigurationForm(sslConfiguration, false).toXML();
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="ssl.html")
    public void setSSLConfiguration(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ConfigurationForm sslForm = this.htmlFormParser.parseSSLConfigurationForm(request.getBody(), false);
        if (this.validator.validate(sslForm)) {
            if (((AccessPointConfigurationManager)this.configurationManager).setSSLConfiguration(sslForm.toSSLConfiguration())) {
                response.respondMessage("SSL settings updated. Restarting service...");
            } else {
                Document document = sslForm.toXML();
                response.respondDocument(document, request.isGzipEncodingAccepted());
            }
        } else {
            Document document = sslForm.toXML();
            response.respondDocument(document, request.isGzipEncodingAccepted());
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="thinApMode.xml")
    public void setThinAPMode(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ThinAPConfiguration newConfig = this.xmlSerializer.parseThinAPModeXML(request.getBody().getContent());
        ThinAPConfiguration.Difference diff = (newConfig = ThinAPConfiguration.updateTLSSetting((ThinAPConfiguration)newConfig, (boolean)newConfig.isTLSEnabled(), (boolean)((AccessPointConfigurationManager)this.configurationManager).getThinAPConfiguration().isTLSStrictVerficationEnabled())).getDifferenceTo(((AccessPointConfigurationManager)this.configurationManager).getThinAPConfiguration());
        if (diff.isDifferent()) {
            ((AccessPointConfigurationManager)this.configurationManager).setThinAPConfiguration(newConfig);
            String responseMessage = "";
            if (diff.isConnectionModeDifferent() || diff.isTLSDifferent()) {
                ((AccessPointBackendControl)this.backendControl).initCreateESLEnvironmentFile();
                ((AccessPointBackendControl)this.backendControl).initCommunicationDaemonRestart();
                responseMessage = responseMessage + "Connection mode updated. Communication daemon restart initialized. ";
            }
            if (diff.isThinModeDifferent()) {
                responseMessage = responseMessage + "ThinAP mode updated. Service restart initialized.";
                response.respondMessage(responseMessage);
                ((AccessPointBackendControl)this.backendControl).initServiceRestart();
            } else {
                response.respondMessage(responseMessage);
            }
        } else {
            response.respondMessage("ThinAP mode unchanged.");
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="service/restartDaemon.xml")
    public void restartDaemon(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ((AccessPointBackendControl)this.backendControl).initCommunicationDaemonRestart();
        response.respondMessage("Communication Daemon restart initialized.");
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="certificate/thinap/upload.html")
    public void uploadThinApCertificate(WebserviceRequest request, WebserviceResponse response) throws Exception {
        HttpEntity body = request.getBody();
        if (body.getContentType().getValue().contains("multipart/form-data")) {
            MultipartFileParser parser = new MultipartFileParser();
            File file = parser.writeFileFromStream(body, UPLOADS_FOLDER);
            if (file != null) {
                BackendTaskStatus status = ((AccessPointBackendControl)this.backendControl).initThinAPTLSUpdate(file.getName());
                if (status == BackendTaskStatus.FAILED) {
                    response.respondMessage("Could not upload certificate.", 400);
                } else {
                    response.respondMessage(String.format("Certificate(s) uploaded", new Object[0]));
                }
            } else {
                response.respondMessage("Could not read certificate.", 400);
            }
        } else {
            response.respondBadRequest();
        }
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="certificate/thinap/view.xml")
    public void getThinApCertificate(WebserviceRequest request, WebserviceResponse response) throws Exception {
        Document document = this.tlsCertificateSerializer.certificateToXML();
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="certificate/thinap/certificate.pem")
    public void downloadThinApCertificatePEM(WebserviceRequest request, WebserviceResponse response) throws Exception {
        response.respondPEM(this.tlsCertificateSerializer.getCertificatePEM());
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="certificate/thinap/certificate.der")
    public void downloadThinApCertificateDER(WebserviceRequest request, WebserviceResponse response) throws Exception {
        response.respondDER(this.tlsCertificateSerializer.getCertificateDER());
    }

    @Restrict
    @Route(method=HttpRequestMethod.POST, route="certificate/thinap/restoreCertificate.html")
    public void generateThinApDefaultCertificate(WebserviceRequest request, WebserviceResponse response) throws Exception {
        BackendTaskStatus status = ((AccessPointBackendControl)this.backendControl).initThinAPTLSReset();
        if (status == BackendTaskStatus.FAILED) {
            response.respondMessage("Could not restored default certificate.", 400);
        } else {
            response.respondMessage("Restored default certificate.", 200);
        }
    }

    public String getRouteFromPattern(String route) {
        return route;
    }
}

