/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.command;

public class TransmissionIdProvider {
    public static final int DEFAULT_MIN_TRANSMISSION_ID = 1;
    public static final int DEFAULT_MAX_TRANSMISSION_ID = 255;
    private final int minTransmissionId;
    private final int maxTransmissionId;
    private int currentTransmissionId;

    public TransmissionIdProvider() {
        this(1, 255);
    }

    public TransmissionIdProvider(int minTransmissionId, int maxTransmissionId) {
        if (minTransmissionId >= maxTransmissionId) {
            throw new IllegalArgumentException("Min transmission ID must be smaller than max");
        }
        this.minTransmissionId = minTransmissionId;
        this.maxTransmissionId = maxTransmissionId;
        this.currentTransmissionId = minTransmissionId - 1;
    }

    public int getCurrentTransmissionId() {
        return this.currentTransmissionId;
    }

    public int getNextTransmissionId() {
        this.currentTransmissionId = this.currentTransmissionId == this.maxTransmissionId ? this.minTransmissionId : ++this.currentTransmissionId;
        return this.currentTransmissionId;
    }
}

