/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.command;

import at.mrdevelopment.esl.accesspoint.TransmissionSettings;
import at.mrdevelopment.esl.accesspoint.command.AuxPageDataCommand;
import at.mrdevelopment.esl.accesspoint.command.BasicLEDDurationFlashingCommand;
import at.mrdevelopment.esl.accesspoint.command.BasicLEDRepeatCountFlashingCommand;
import at.mrdevelopment.esl.accesspoint.command.CommittedDataCommand;
import at.mrdevelopment.esl.accesspoint.command.CommittedPingCommand;
import at.mrdevelopment.esl.accesspoint.command.EventConfirmCommand;
import at.mrdevelopment.esl.accesspoint.command.FirmwareDataCommand;
import at.mrdevelopment.esl.accesspoint.command.ForceChannelScanCommand;
import at.mrdevelopment.esl.accesspoint.command.GetConfigCommand;
import at.mrdevelopment.esl.accesspoint.command.ImageDataCommand;
import at.mrdevelopment.esl.accesspoint.command.InitializeCommand;
import at.mrdevelopment.esl.accesspoint.command.JoinCommand;
import at.mrdevelopment.esl.accesspoint.command.PingCommand;
import at.mrdevelopment.esl.accesspoint.command.QueryCounterCommand;
import at.mrdevelopment.esl.accesspoint.command.QuerySensorCommand;
import at.mrdevelopment.esl.accesspoint.command.RebootCommand;
import at.mrdevelopment.esl.accesspoint.command.RefreshDisplayCommand;
import at.mrdevelopment.esl.accesspoint.command.ResetCounterCommand;
import at.mrdevelopment.esl.accesspoint.command.SetConfigCommand;
import at.mrdevelopment.esl.accesspoint.command.SetKeyCommand;
import at.mrdevelopment.esl.accesspoint.command.SwitchPageCommand;
import at.mrdevelopment.esl.accesspoint.command.TransmissionCommand;
import at.mrdevelopment.esl.accesspoint.command.UnlockCommand;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.core.security.Key;
import at.mrdevelopment.esl.updatetask.AuxPageUpdateTask;
import at.mrdevelopment.esl.updatetask.BasicLEDDurationFlashingUpdateTask;
import at.mrdevelopment.esl.updatetask.BasicLEDFlashingUpdateTask;
import at.mrdevelopment.esl.updatetask.BasicLEDRepeatCountFlashingUpdateTask;
import at.mrdevelopment.esl.updatetask.CommandUpdateTask;
import at.mrdevelopment.esl.updatetask.DataUpdateTask;
import at.mrdevelopment.esl.updatetask.EventConfirmUpdateTask;
import at.mrdevelopment.esl.updatetask.FirmwareUpdateTask;
import at.mrdevelopment.esl.updatetask.ForceChannelScanUpdateTask;
import at.mrdevelopment.esl.updatetask.GetConfigUpdateTask;
import at.mrdevelopment.esl.updatetask.ImageUpdateTask;
import at.mrdevelopment.esl.updatetask.InitializeUpdateTask;
import at.mrdevelopment.esl.updatetask.InternalPingUpdateTask;
import at.mrdevelopment.esl.updatetask.JoinUpdateTask;
import at.mrdevelopment.esl.updatetask.PingUpdateTask;
import at.mrdevelopment.esl.updatetask.QueryCounterUpdateTask;
import at.mrdevelopment.esl.updatetask.QuerySensorUpdateTask;
import at.mrdevelopment.esl.updatetask.RebootUpdateTask;
import at.mrdevelopment.esl.updatetask.RefreshDisplayUpdateTask;
import at.mrdevelopment.esl.updatetask.ResetAllCountersUpdateTask;
import at.mrdevelopment.esl.updatetask.ResetCounterUpdateTask;
import at.mrdevelopment.esl.updatetask.SetConfigUpdateTask;
import at.mrdevelopment.esl.updatetask.SetKeyUpdateTask;
import at.mrdevelopment.esl.updatetask.SwitchPageUpdateTask;
import at.mrdevelopment.esl.updatetask.UnlockLabelUpdateTask;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Set;
import java.util.UUID;

public class TransmissionCommandFactory {
    static ESLLogger logger = ESLLogger.getLogger(TransmissionCommandFactory.class);

    public CommittedDataCommand<?> toDataCommand(DataUpdateTask updateTask, Key key, TransmissionSettings transmissionSettings, int dataTransmissionId) {
        if (updateTask instanceof SetKeyUpdateTask) {
            logger.info("Sending set key to label %s", new Object[]{updateTask.getAddress()});
            return new SetKeyCommand(UUID.randomUUID(), (SetKeyUpdateTask)updateTask, key, transmissionSettings, dataTransmissionId);
        }
        if (updateTask instanceof ImageUpdateTask) {
            logger.info("Sending image to label %s", new Object[]{updateTask.getAddress()});
            return new ImageDataCommand((ImageUpdateTask)updateTask, key, transmissionSettings, dataTransmissionId);
        }
        if (updateTask instanceof FirmwareUpdateTask) {
            logger.info("Sending firmware to label %s", new Object[]{updateTask.getAddress()});
            return new FirmwareDataCommand((FirmwareUpdateTask)updateTask, key, transmissionSettings, dataTransmissionId);
        }
        if (updateTask instanceof UnlockLabelUpdateTask) {
            logger.info("Unlocking label %s", new Object[]{updateTask.getAddress()});
            return new UnlockCommand((UnlockLabelUpdateTask)updateTask, key, transmissionSettings, dataTransmissionId);
        }
        if (updateTask instanceof InitializeUpdateTask) {
            logger.info("Initializing label %s", new Object[]{updateTask.getAddress()});
            return new InitializeCommand((InitializeUpdateTask)updateTask, key, transmissionSettings, dataTransmissionId);
        }
        if (updateTask instanceof AuxPageUpdateTask) {
            logger.info("Programming AUX page for label %s", new Object[]{updateTask.getAddress()});
            return new AuxPageDataCommand((AuxPageUpdateTask)updateTask, key, transmissionSettings, dataTransmissionId);
        }
        logger.warn("Can't convert unknown data update task %s", new Object[]{updateTask.getClass().getSimpleName()});
        return null;
    }

    public TransmissionCommand toCommand(CommandUpdateTask updateTask, Set<WirelessChannel> usedChannels) {
        if (updateTask instanceof InternalPingUpdateTask) {
            return new PingCommand((InternalPingUpdateTask)updateTask);
        }
        if (updateTask instanceof JoinUpdateTask) {
            return new JoinCommand((JoinUpdateTask)updateTask);
        }
        if (updateTask instanceof EventConfirmUpdateTask) {
            return new EventConfirmCommand((EventConfirmUpdateTask)updateTask);
        }
        if (updateTask instanceof SwitchPageUpdateTask) {
            return new SwitchPageCommand((SwitchPageUpdateTask)updateTask);
        }
        if (updateTask instanceof RefreshDisplayUpdateTask) {
            return new RefreshDisplayCommand((RefreshDisplayUpdateTask)updateTask);
        }
        if (updateTask instanceof QuerySensorUpdateTask) {
            return new QuerySensorCommand((QuerySensorUpdateTask)updateTask);
        }
        if (updateTask instanceof SetConfigUpdateTask) {
            return new SetConfigCommand((SetConfigUpdateTask)updateTask);
        }
        if (updateTask instanceof GetConfigUpdateTask) {
            return new GetConfigCommand((GetConfigUpdateTask)updateTask);
        }
        if (updateTask instanceof ResetAllCountersUpdateTask) {
            return new ResetCounterCommand((ResetAllCountersUpdateTask)updateTask);
        }
        if (updateTask instanceof ResetCounterUpdateTask) {
            return new ResetCounterCommand((ResetCounterUpdateTask)updateTask);
        }
        if (updateTask instanceof QueryCounterUpdateTask) {
            return new QueryCounterCommand((QueryCounterUpdateTask)updateTask);
        }
        if (updateTask instanceof ForceChannelScanUpdateTask) {
            ForceChannelScanUpdateTask forceChannelScanUpdateTask = (ForceChannelScanUpdateTask)updateTask;
            Set<WirelessChannel> channels = forceChannelScanUpdateTask.isScanAllChannels() ? WirelessChannel.valueSet() : usedChannels;
            return new ForceChannelScanCommand(forceChannelScanUpdateTask, channels);
        }
        if (updateTask instanceof RebootUpdateTask) {
            return new RebootCommand((RebootUpdateTask)updateTask);
        }
        if (updateTask instanceof PingUpdateTask) {
            return new CommittedPingCommand((PingUpdateTask)updateTask);
        }
        if (updateTask instanceof BasicLEDRepeatCountFlashingUpdateTask) {
            return new BasicLEDRepeatCountFlashingCommand((BasicLEDFlashingUpdateTask)((BasicLEDRepeatCountFlashingUpdateTask)updateTask));
        }
        if (updateTask instanceof BasicLEDDurationFlashingUpdateTask) {
            return new BasicLEDDurationFlashingCommand((BasicLEDFlashingUpdateTask)((BasicLEDDurationFlashingUpdateTask)updateTask));
        }
        logger.warn("Can't convert unknown update task %s", new Object[]{updateTask.getClass().getSimpleName()});
        return null;
    }
}

