/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.command;

import at.mrdevelopment.esl.accesspoint.serial.FrameOutputStream;
import at.mrdevelopment.esl.core.security.Key;
import at.mrdevelopment.esl.wireless.Address;
import java.io.IOException;

public abstract class TransmissionCommand {
    public static final int COMMAND_DATA_SIZE = 2;
    public static final int COMMAND_REPLY_DATA_SIZE = 4;
    public static final int COMMAND_ID_MASK = 15;
    private final int commandHeader;
    private final Address address;
    private final Key key;

    public TransmissionCommand(int commandHeader, Address address, Key key) {
        this.commandHeader = commandHeader;
        this.address = address;
        this.key = key;
    }

    public Address getAddress() {
        return this.address;
    }

    public Key getKey() {
        return this.key;
    }

    public boolean isEncrypted() {
        return this.key != null;
    }

    public void writeKey(FrameOutputStream serialStream) throws IOException {
        if (this.key != null) {
            serialStream.writeBytes(this.key.toBytes());
        } else {
            serialStream.writeBytes(Key.emptyKey().toBytes());
        }
    }

    public void writeCommand(FrameOutputStream serialStream) throws IOException {
        serialStream.writeByte(this.getCommandHeader());
        serialStream.writeAddressPart(this.getAddress());
        this.writeCommandData(serialStream);
    }

    public int getCommandId() {
        return this.commandHeader & 0xF;
    }

    protected int getCommandHeader() {
        return this.commandHeader;
    }

    protected void writeCommandData(FrameOutputStream serialStream) throws IOException {
        for (int index = 0; index < 2; ++index) {
            serialStream.writeByte(0);
        }
    }

    public String toString() {
        return String.format("%s %s", this.getClass().getSimpleName(), this.address);
    }
}

