/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.command;

import at.mrdevelopment.esl.accesspoint.SlotId;
import at.mrdevelopment.esl.accesspoint.command.CommittedDataCommand;
import at.mrdevelopment.esl.accesspoint.command.EmptyCommand;
import at.mrdevelopment.esl.accesspoint.command.SyncCommandType;
import at.mrdevelopment.esl.accesspoint.command.TransmissionCommand;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.Packet;
import at.mrdevelopment.esl.wireless.SyncProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.lang.StringUtils;

public class SyncPacket
extends Packet {
    private final SlotId slotId;
    private final SyncProfile syncProfile;
    private final SyncCommandType commandType;
    private final CommittedDataCommand<?> dataCommand;
    private final List<? extends TransmissionCommand> commands;
    private final int dataTransmissionId;
    private final boolean joinRequestAllowed;

    public static SyncPacket createDataInit(SlotId slotId, SyncProfile syncProfile, CommittedDataCommand<?> dataCommand, int commandCount) {
        return new SyncPacket(slotId, syncProfile, SyncCommandType.DATA_INIT, dataCommand, SyncPacket.getEmptyCommands(commandCount), dataCommand.isJoinRequestAllowed());
    }

    public static SyncPacket createCommandList(SlotId slotId, SyncProfile syncProfile, Collection<TransmissionCommand> commands, boolean joinRequestAllowed) {
        return new SyncPacket(slotId, syncProfile, SyncCommandType.COMMAND_LIST, null, new ArrayList<TransmissionCommand>(commands), joinRequestAllowed);
    }

    public static SyncPacket createEmpty(SlotId slotId, SyncProfile syncProfile, int commandCount, boolean joinRequestAllowed) {
        return new SyncPacket(slotId, syncProfile, SyncCommandType.EMPTY, null, SyncPacket.getEmptyCommands(commandCount), joinRequestAllowed);
    }

    public static SyncPacket createEmpty(SlotId slotId, SyncProfile syncProfile, int commandCount) {
        return new SyncPacket(slotId, syncProfile, SyncCommandType.EMPTY, null, SyncPacket.getEmptyCommands(commandCount));
    }

    public static SyncPacket createInvalid(SlotId slotId, SyncProfile syncProfile, int commandCount) {
        return new SyncPacket(slotId, syncProfile, SyncCommandType.INVALID, null, SyncPacket.getEmptyCommands(commandCount));
    }

    private static List<TransmissionCommand> getEmptyCommands(int commandCount) {
        ArrayList<TransmissionCommand> commands = new ArrayList<TransmissionCommand>(commandCount);
        for (int index = 0; index < commandCount; ++index) {
            commands.add(EmptyCommand.INSTANCE);
        }
        return commands;
    }

    private SyncPacket(SlotId slotId, SyncProfile syncProfile, SyncCommandType commandType, CommittedDataCommand<?> dataCommand, List<? extends TransmissionCommand> commands) {
        this(slotId, syncProfile, commandType, dataCommand, commands, false);
    }

    private SyncPacket(SlotId slotId, SyncProfile syncProfile, SyncCommandType commandType, CommittedDataCommand<?> dataCommand, List<? extends TransmissionCommand> commands, boolean joinRequestAllowed) {
        super(Address.BROADCAST);
        this.slotId = slotId;
        this.syncProfile = syncProfile;
        this.commandType = commandType;
        this.dataCommand = dataCommand;
        this.commands = commands;
        this.dataTransmissionId = dataCommand != null ? dataCommand.getDataTranmissionId() : 0;
        this.joinRequestAllowed = joinRequestAllowed;
    }

    public SyncPacket withCorrectCommandType() {
        return this.withCorrectCommandType(false);
    }

    public SyncPacket withCorrectCommandType(boolean activeDataTransmission) {
        if (this.commandType.isDataInit()) {
            return this;
        }
        if (activeDataTransmission) {
            return this.commandType.isData() ? this : new SyncPacket(this.slotId, this.syncProfile, SyncCommandType.DATA, this.dataCommand, this.commands, this.joinRequestAllowed);
        }
        if (this.getNonEmptyCommandCount() > 0) {
            return this.commandType.isCommandList() ? this : new SyncPacket(this.slotId, this.syncProfile, SyncCommandType.COMMAND_LIST, this.dataCommand, this.commands);
        }
        return this.commandType.isEmpty() ? this : new SyncPacket(this.slotId, this.syncProfile, SyncCommandType.EMPTY, this.dataCommand, this.commands);
    }

    public SyncCommandType getCommandType() {
        return this.commandType;
    }

    public boolean isValid() {
        return this.commandType.isValid();
    }

    public SlotId getSlotId() {
        return this.slotId;
    }

    public SyncProfile getSyncProfile() {
        return this.syncProfile;
    }

    public CommittedDataCommand<?> getDataCommand() {
        return this.dataCommand;
    }

    public boolean isJoinRequestAllowed() {
        return this.joinRequestAllowed;
    }

    public List<? extends TransmissionCommand> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public Collection<? extends TransmissionCommand> getNonEmptyCommands() {
        return CollectionUtils.select(this.commands, (Predicate)new Predicate<TransmissionCommand>(){

            public boolean evaluate(TransmissionCommand command) {
                return command != EmptyCommand.INSTANCE;
            }
        });
    }

    public int getNonEmptyCommandCount() {
        return this.getNonEmptyCommands().size();
    }

    public int getCommandCount() {
        return this.commands.size();
    }

    public TransmissionCommand getCommand(int replySlot) {
        return this.commands.get(replySlot);
    }

    public int getDataTransmissionId() {
        return this.dataTransmissionId;
    }

    public String toString() {
        return String.format("%s slot=%s, %12s { %s }", new Object[]{super.toString(), this.slotId, this.commandType, this.getCommandsString()});
    }

    private String getCommandsString() {
        return this.commandType.isDataInit() ? this.dataCommand.toString() : StringUtils.join(this.commands, (String)", ");
    }

    public boolean joinAllowed() {
        if (this.commandType == SyncCommandType.DATA) {
            return this.isJoinRequestAllowed();
        }
        return this.commandType.isJoinRequestAllowed();
    }
}

