/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.command;

public enum SyncCommandType {
    EMPTY(0),
    INVALID(0),
    DATA_INIT(4),
    DATA(8),
    COMMAND_LIST(12);

    private final int id;

    private SyncCommandType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean isValid() {
        return this != INVALID;
    }

    public boolean isDataInit() {
        return this == DATA_INIT;
    }

    public boolean isData() {
        return this == DATA;
    }

    public boolean isCommandList() {
        return this == COMMAND_LIST;
    }

    public boolean isJoinRequestAllowed() {
        return this == COMMAND_LIST || this == EMPTY;
    }

    public boolean isEventAllowed() {
        return this == COMMAND_LIST || this == EMPTY;
    }

    public static SyncCommandType fromId(int id) {
        for (SyncCommandType type : SyncCommandType.values()) {
            if (type.id != id) continue;
            return type;
        }
        return null;
    }
}

