/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.command;

import at.mrdevelopment.esl.accesspoint.command.CommittedCommand;
import at.mrdevelopment.esl.accesspoint.serial.FrameOutputStream;
import at.mrdevelopment.esl.core.labeltype.LabelLookupTables;
import at.mrdevelopment.esl.updatetask.SwitchPageUpdateTask;
import at.mrdevelopment.toolkit.firmware.LabelLookupTable;
import java.io.IOException;

public class SwitchPageCommand
extends CommittedCommand<SwitchPageUpdateTask> {
    public static final int COMMAND_ID = 2;

    public SwitchPageCommand(SwitchPageUpdateTask updateTask) {
        super(2, updateTask, null);
    }

    @Override
    protected void writeCommandData(FrameOutputStream serialStream) throws IOException {
        SwitchPageUpdateTask updateTask = (SwitchPageUpdateTask)this.getUpdateTask();
        serialStream.writeByte(updateTask.getPage().getPageIndex());
        serialStream.writeByte(this.getClosestDuration());
    }

    private int getClosestDuration() {
        LabelLookupTable lookupTable = LabelLookupTables.SWITCH_PAGE_TIMEOUT.getLookupTable();
        LabelLookupTable.LookupTableIndex closestIndex = lookupTable.findClosestMatch(((SwitchPageUpdateTask)this.getUpdateTask()).getDurationInMinutes());
        int data = (closestIndex.getBaseIndex() & 3) << 3;
        return data |= closestIndex.getStepIndex() & 7;
    }

    @Override
    public String toString() {
        int page = ((SwitchPageUpdateTask)this.getUpdateTask()).getPage().getPageIndex();
        int duration = ((SwitchPageUpdateTask)this.getUpdateTask()).getDurationInMinutes();
        return String.format("SWITCH_PAGE %s, page=%d, durationInMinutes=%d", this.getAddress(), page, duration);
    }
}

