/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.command;

import at.mrdevelopment.esl.accesspoint.command.CommittedCommand;
import at.mrdevelopment.esl.accesspoint.serial.FrameInputStream;
import at.mrdevelopment.esl.accesspoint.serial.FrameOutputStream;
import at.mrdevelopment.esl.updatetask.LabelSensor;
import at.mrdevelopment.esl.updatetask.QuerySensorUpdateTask;
import java.io.IOException;
import java.util.List;

public class QuerySensorCommand
extends CommittedCommand<QuerySensorUpdateTask> {
    public static final int COMMAND_ID = 4;
    public static final int NO_SENSOR_ID = 15;

    public QuerySensorCommand(QuerySensorUpdateTask updateTask) {
        super(4, updateTask, null);
    }

    @Override
    protected void writeCommandData(FrameOutputStream serialStream) throws IOException {
        QuerySensorUpdateTask updateTask = (QuerySensorUpdateTask)this.getUpdateTask();
        List sensors = updateTask.getSensors();
        serialStream.writeByte(sensors.size() >= 1 ? ((LabelSensor)sensors.get(0)).getSensorId() : 15);
        serialStream.writeByte(sensors.size() >= 2 ? ((LabelSensor)sensors.get(1)).getSensorId() : 15);
    }

    @Override
    protected void readReply(FrameInputStream serialStream) throws IOException {
        QuerySensorUpdateTask updateTask = (QuerySensorUpdateTask)this.getUpdateTask();
        List sensors = updateTask.getSensors();
        int sensorValue1 = serialStream.readWord();
        int sensorValue2 = serialStream.readWord();
        if (sensors.size() >= 1) {
            updateTask.setSensorValue((LabelSensor)sensors.get(0), sensorValue1);
        }
        if (sensors.size() >= 2) {
            updateTask.setSensorValue((LabelSensor)sensors.get(1), sensorValue2);
        }
    }
}

