/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.command;

import at.mrdevelopment.esl.accesspoint.command.CommittedCommand;
import at.mrdevelopment.esl.accesspoint.serial.FrameInputStream;
import at.mrdevelopment.esl.accesspoint.serial.FrameOutputStream;
import at.mrdevelopment.esl.updatetask.LabelCounter;
import at.mrdevelopment.esl.updatetask.QueryCounterUpdateTask;
import java.io.IOException;
import java.util.List;

public class QueryCounterCommand
extends CommittedCommand<QueryCounterUpdateTask> {
    public static final int COMMAND_ID = 8;
    public static final int NO_COUNTER_ID = 254;

    public QueryCounterCommand(QueryCounterUpdateTask updateTask) {
        super(8, updateTask, null);
    }

    @Override
    protected void writeCommandData(FrameOutputStream serialStream) throws IOException {
        QueryCounterUpdateTask updateTask = (QueryCounterUpdateTask)this.getUpdateTask();
        List counters = updateTask.getCounters();
        serialStream.writeByte(counters.size() >= 1 ? ((LabelCounter)counters.get(0)).getCounterId() : 254);
        serialStream.writeByte(counters.size() >= 2 ? ((LabelCounter)counters.get(1)).getCounterId() : 254);
    }

    @Override
    protected void readReply(FrameInputStream serialStream) throws IOException {
        QueryCounterUpdateTask updateTask = (QueryCounterUpdateTask)this.getUpdateTask();
        List counters = updateTask.getCounters();
        int counterValue1 = serialStream.readWord();
        int counterValue2 = serialStream.readWord();
        if (counters.size() >= 1) {
            updateTask.setCounterValue((LabelCounter)counters.get(0), counterValue1);
        }
        if (counters.size() >= 2) {
            updateTask.setCounterValue((LabelCounter)counters.get(1), counterValue2);
        }
    }
}

