/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.command;

import at.mrdevelopment.esl.accesspoint.command.CommittedCommand;
import at.mrdevelopment.esl.accesspoint.serial.FrameInputStream;
import at.mrdevelopment.esl.accesspoint.serial.FrameOutputStream;
import at.mrdevelopment.esl.updatetask.GetConfigUpdateTask;
import at.mrdevelopment.esl.updatetask.LabelConfig;
import java.io.IOException;
import java.util.List;

public class GetConfigCommand
extends CommittedCommand<GetConfigUpdateTask> {
    public static final int COMMAND_ID = 6;
    private static final int NO_CONFIG_ID = 255;

    public GetConfigCommand(GetConfigUpdateTask updateTask) {
        super(6, updateTask, null);
    }

    @Override
    protected void writeCommandData(FrameOutputStream serialStream) throws IOException {
        GetConfigUpdateTask updateTask = (GetConfigUpdateTask)this.getUpdateTask();
        List configs = updateTask.getConfigs();
        serialStream.writeByte(configs.size() >= 1 ? ((LabelConfig)configs.get(0)).getConfigId() : 255);
        serialStream.writeByte(255);
    }

    @Override
    protected void readReply(FrameInputStream serialStream) throws IOException {
        GetConfigUpdateTask updateTask = (GetConfigUpdateTask)this.getUpdateTask();
        List configs = updateTask.getConfigs();
        if (configs.size() >= 1) {
            LabelConfig config = (LabelConfig)configs.get(0);
            if (config.getType() == LabelConfig.Type.UNSIGNED_WORD_32) {
                updateTask.setConfigValue(config, serialStream.read32BitWord());
            } else if (config.getType() == LabelConfig.Type.UNSIGNED_WORD_16) {
                updateTask.setConfigValue(config, serialStream.readWord());
                serialStream.skipBytes(2);
            } else if (config.getType() == LabelConfig.Type.SIGNED_WORD_16) {
                updateTask.setConfigValue(config, serialStream.readSignedWord());
                serialStream.skipBytes(2);
            } else if (config.getType() == LabelConfig.Type.SIGNED_BYTE) {
                updateTask.setConfigValue(config, serialStream.readSignedByte());
                serialStream.skipBytes(3);
            } else if (config.getType() == LabelConfig.Type.UNSIGNED_BYTE) {
                updateTask.setConfigValue(config, serialStream.readByte());
                serialStream.skipBytes(3);
            } else {
                super.readReply(serialStream);
            }
        } else {
            super.readReply(serialStream);
        }
    }
}

