/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.command;

import at.mrdevelopment.esl.accesspoint.CompressionProperties;
import at.mrdevelopment.esl.accesspoint.TransmissionSettings;
import at.mrdevelopment.esl.accesspoint.command.TransmissionCommand;
import at.mrdevelopment.esl.accesspoint.serial.FrameOutputStream;
import at.mrdevelopment.esl.core.security.Key;
import at.mrdevelopment.esl.wireless.Address;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;

public abstract class DataCommand
extends TransmissionCommand {
    private static final int CHANNEL_LIST_SIZE = 4;
    private final UUID id;
    private final byte[] data;
    private final int fileSize;
    private final int windowSize;
    private final int payloadSize;
    private final CompressionProperties compressionProperties;
    private final int dataTransmissionId;
    private final boolean joinRequestAllowed;

    public DataCommand(UUID id, int commandHeader, Address address, Key key, byte[] data, CompressionProperties compressionProperties, TransmissionSettings transmissionSettings, int dataTransmissionId) {
        this(id, commandHeader, address, key, data, compressionProperties, transmissionSettings.getMaxWindowSize(), transmissionSettings.getMaxPayloadSize(), transmissionSettings.isJoinRequestAllowed(), dataTransmissionId);
    }

    protected DataCommand(UUID id, int commandHeader, Address address, Key key, int fileSize, CompressionProperties compressionProperties, int windowSize, int payloadSize, boolean joinRequestAllowed, int dataTransmissionId) {
        super(commandHeader | (compressionProperties.isCompressed() ? 16 : 0), address, key);
        this.id = id;
        this.compressionProperties = compressionProperties;
        this.fileSize = fileSize;
        this.windowSize = windowSize;
        this.payloadSize = payloadSize;
        this.joinRequestAllowed = joinRequestAllowed;
        this.dataTransmissionId = dataTransmissionId;
        this.data = new byte[0];
    }

    private DataCommand(UUID id, int commandHeader, Address address, Key key, byte[] data, CompressionProperties compressionProperties, int windowSize, int payloadSize, boolean joinRequestAllowed, int dataTransmissionId) {
        super(commandHeader | (compressionProperties.isCompressed() ? 16 : 0), address, key);
        this.id = id;
        this.compressionProperties = compressionProperties;
        this.fileSize = data.length;
        this.windowSize = windowSize;
        this.payloadSize = payloadSize;
        this.joinRequestAllowed = joinRequestAllowed;
        this.dataTransmissionId = dataTransmissionId;
        int length = (int)Math.ceil((double)data.length / (double)payloadSize) * payloadSize;
        this.data = Arrays.copyOf(data, length);
    }

    @Override
    public void writeCommand(FrameOutputStream serialStream) throws IOException {
        serialStream.writeByte(this.getCommandHeader());
        serialStream.writeAddress(this.getAddress());
        this.writeCommandData(serialStream);
    }

    @Override
    protected void writeCommandData(FrameOutputStream serialStream) throws IOException {
        serialStream.writeInteger24(this.fileSize);
        serialStream.writeByte(this.windowSize);
        serialStream.writeByte(this.payloadSize);
        serialStream.writeByte(this.dataTransmissionId);
        serialStream.writeWord(0);
        serialStream.writeByte((this.isEncrypted() ? 1 : 0) | this.compressionProperties.getCompressionType() << 1);
        for (int index = 0; index < 4; ++index) {
            serialStream.writeByte(0);
        }
    }

    public UUID getId() {
        return this.id;
    }

    public int getPayloadSize() {
        return this.payloadSize;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public boolean isJoinRequestAllowed() {
        return this.joinRequestAllowed;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public CompressionProperties getCompressionProperties() {
        return this.compressionProperties;
    }

    public byte[] getDataBytes() {
        return this.data;
    }

    public int getDataLength() {
        return this.data.length;
    }

    public int getBlockedSlots(int minUsablePacketPerSlots) {
        double packetCount = Math.ceil((double)this.data.length / (double)this.payloadSize);
        double dataSlots = Math.ceil(packetCount / (double)Math.min(this.windowSize, minUsablePacketPerSlots));
        return (int)Math.ceil(dataSlots * 1.25 + 2.0);
    }

    public int getActualId() {
        return this.getCommandHeader() & 0xE0;
    }

    public int getDataTranmissionId() {
        return this.dataTransmissionId;
    }

    @Override
    public String toString() {
        return String.format("%s, fileSize=%d, windowSize=%d, payloadSize=%d, compressed=%b, encrypted=%b, dataTransmissionId=%d", this.getAddress(), this.fileSize, this.windowSize, this.payloadSize, this.compressionProperties.isCompressed(), this.isEncrypted(), this.dataTransmissionId);
    }
}

