/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.command;

import at.mrdevelopment.esl.core.WirelessChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ChannelMask {
    private final Set<WirelessChannel> channels;

    public ChannelMask(Set<WirelessChannel> channels) {
        this.channels = channels;
    }

    public static ChannelMask empty() {
        Set<WirelessChannel> emptyUsedChannels = Collections.emptySet();
        return new ChannelMask(emptyUsedChannels);
    }

    public static ChannelMask all() {
        return new ChannelMask(WirelessChannel.valueSet());
    }

    public Set<WirelessChannel> getSelectedChannels() {
        return this.channels;
    }

    public int getMask() {
        int usedChannelsMask = 0;
        for (WirelessChannel channel : this.channels) {
            int channelId = channel.getChannelId();
            usedChannelsMask |= 1 << channelId;
        }
        return usedChannelsMask;
    }

    public static Set<WirelessChannel> getSetFromMask(int mask) {
        HashSet<WirelessChannel> channels = new HashSet<WirelessChannel>();
        for (WirelessChannel c : WirelessChannel.values()) {
            if ((mask & 1 << c.getChannelId()) <= 0) continue;
            channels.add(c);
        }
        return channels;
    }
}

