/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint.command;

import at.mrdevelopment.esl.accesspoint.command.CommittedCommand;
import at.mrdevelopment.esl.accesspoint.serial.FrameOutputStream;
import at.mrdevelopment.esl.updatetask.BasicLEDFlashingUpdateTask;
import java.io.IOException;

public abstract class BasicLEDFlashingCommand
extends CommittedCommand<BasicLEDFlashingUpdateTask> {
    public static final int COMMAND_ID = 5;
    private final int subCommandId;

    public BasicLEDFlashingCommand(BasicLEDFlashingUpdateTask updateTask, int subCommandId) {
        super(5, updateTask, null);
        this.subCommandId = subCommandId;
    }

    @Override
    protected void writeCommandData(FrameOutputStream serialStream) throws IOException {
        BasicLEDFlashingUpdateTask updateTask = (BasicLEDFlashingUpdateTask)this.getUpdateTask();
        int color = updateTask.getColor();
        int pattern = updateTask.getPattern();
        int period = this.calculateEffectivePeriod(updateTask.getPeriod());
        int data = 32768;
        data |= (this.subCommandId & 0xF) << 11;
        data |= (color & 7) << 8;
        data |= (pattern & 7) << 5;
        serialStream.write((data |= period & 0x1F) >> 8);
        serialStream.write(data);
    }

    protected abstract int calculateEffectivePeriod(int var1);
}

