/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.FillSyncQueueCommandCreator;
import at.mrdevelopment.esl.accesspoint.ProtocolSettings;
import at.mrdevelopment.esl.accesspoint.ProtocolSettingsProvider;
import at.mrdevelopment.esl.accesspoint.SlotId;
import at.mrdevelopment.esl.accesspoint.WirelessTransmitter;
import at.mrdevelopment.esl.accesspoint.taskqueue.SlotPipeline;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ESLLogger;

public abstract class WirelessTransmitterBase
implements Shutdownable {
    private static ESLLogger logger = ESLLogger.getLogger(WirelessTransmitter.class);
    protected final SlotPipeline slotPipeline;
    protected final ProtocolSettingsProvider protocolSettingsProvider;
    protected final FillSyncQueueCommandCreator commandCreator;
    private volatile boolean shutdownRequested;

    public WirelessTransmitterBase(SlotPipeline slotPipeline, ProtocolSettingsProvider protocolSettingsProvider) {
        this.slotPipeline = slotPipeline;
        this.protocolSettingsProvider = protocolSettingsProvider;
        this.shutdownRequested = false;
        this.commandCreator = new FillSyncQueueCommandCreator();
    }

    public ProtocolSettings getProtocolSettings() {
        return this.protocolSettingsProvider.getProtocolSettings();
    }

    protected void pretendAddReply(SlotId slotId) {
        this.slotPipeline.pretendAddReply(slotId, this.commandCreator);
    }

    public void shutdown() {
        this.shutdownRequested = true;
        logger.info("Wireless transmitter terminated");
    }

    protected boolean shutdownRequested() {
        return this.shutdownRequested;
    }
}

