/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPointProblem;
import at.mrdevelopment.esl.accesspoint.ProtocolSettings;
import at.mrdevelopment.esl.accesspoint.ProtocolSettingsProvider;
import at.mrdevelopment.esl.accesspoint.SlotId;
import at.mrdevelopment.esl.accesspoint.TransmissionStatus;
import at.mrdevelopment.esl.accesspoint.WirelessTransmitterBase;
import at.mrdevelopment.esl.accesspoint.command.DataCommand;
import at.mrdevelopment.esl.accesspoint.command.SyncPacket;
import at.mrdevelopment.esl.accesspoint.taskqueue.ActiveCommandLogic;
import at.mrdevelopment.esl.accesspoint.taskqueue.ActiveCommandLogicResult;
import at.mrdevelopment.esl.accesspoint.taskqueue.ActiveDataCommand;
import at.mrdevelopment.esl.accesspoint.taskqueue.ReplyQueueEntry;
import at.mrdevelopment.esl.accesspoint.taskqueue.SlotPipeline;
import at.mrdevelopment.esl.core.TransmissionInfo;
import at.mrdevelopment.esl.wireless.EventPacket;
import at.mrdevelopment.esl.wireless.JoinRequest;
import at.mrdevelopment.esl.wireless.Reply;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Collection;
import org.joda.time.DateTime;

public abstract class WirelessTransmitter
extends WirelessTransmitterBase {
    private static ESLLogger logger = ESLLogger.getLogger(WirelessTransmitter.class);
    protected final ActiveCommandLogic activeCommandLogic = new ActiveCommandLogic();

    public WirelessTransmitter(SlotPipeline slotPipeline, ProtocolSettingsProvider protocolSettingsProvider) {
        super(slotPipeline, protocolSettingsProvider);
    }

    public void slotTimerTick(SlotId slotId, DateTime now) {
    }

    protected SyncPacket getSyncPacket(SlotId slotId, DateTime now) {
        ProtocolSettings protocolSettings = this.protocolSettingsProvider.getProtocolSettings();
        SyncPacket syncPacket = this.slotPipeline.getSyncForForwarding(slotId);
        if (syncPacket == null) {
            logger.info("Sync queue is empty at slot %s", new Object[]{slotId});
            return SyncPacket.createEmpty(slotId, protocolSettings.getSyncProfile(), 3);
        }
        if (!syncPacket.getSlotId().equals(slotId)) {
            logger.info("Got sync for slot %s, expected %s", new Object[]{syncPacket.getSlotId(), slotId});
            return SyncPacket.createEmpty(slotId, protocolSettings.getSyncProfile(), 3);
        }
        ActiveCommandLogicResult result = this.activeCommandLogic.getSyncProcess(slotId, syncPacket);
        if (result.isNewSyncRequired()) {
            return SyncPacket.createEmpty(slotId, protocolSettings.getSyncProfile(), 3).withCorrectCommandType(true);
        }
        return syncPacket.withCorrectCommandType(!result.currentCommand().isEmpty());
    }

    protected void addReplies(SlotId slotId, TransmissionStatus transmissionStatus, TransmissionInfo transmissionInfo, Reply[] replies, JoinRequest[] joinRequests, EventPacket[] events, boolean uartError, Collection<AccessPointProblem> problems) {
        ActiveCommandLogic.ReplyProcessResult result = this.activeCommandLogic.addRepliesProcess(transmissionStatus);
        ActiveDataCommand activeCommand = result.getActiveDataCommand();
        this.slotPipeline.addReplies(new ReplyQueueEntry(slotId, result.getStatus(), transmissionInfo, activeCommand.getTransmissionSlots(), replies, joinRequests, events, uartError, problems, activeCommand.getCommandId(), result.getPipelineHazardCommandId()), this.commandCreator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncPacket addRepliesAndGetSyncPacket(SlotId slotId, TransmissionStatus transmissionStatus, TransmissionInfo transmissionInfo, Reply[] replies, JoinRequest[] joinRequests, EventPacket[] events, boolean uartError, Collection<AccessPointProblem> problems, DateTime now) {
        if (transmissionStatus != TransmissionStatus.NO_TRANSMISSION || uartError) {
            logger.info("%s: transmissionStatus=%s, uartError=%b", new Object[]{slotId, transmissionStatus, uartError});
        }
        SlotPipeline slotPipeline = this.slotPipeline;
        synchronized (slotPipeline) {
            this.addReplies(slotId.forReply(), transmissionStatus, transmissionInfo, replies, joinRequests, events, uartError, problems);
            return this.getSyncPacket(slotId, now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataCommand getActiveDataCommand() {
        SlotPipeline slotPipeline = this.slotPipeline;
        synchronized (slotPipeline) {
            return this.activeCommandLogic.getCurrentCommand().getDataCommand();
        }
    }
}

