/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPointMessageForwarder;
import at.mrdevelopment.esl.accesspoint.ProtocolSettingsProvider;
import at.mrdevelopment.esl.accesspoint.SlotIdReader;
import at.mrdevelopment.esl.accesspoint.SlotPipelineProcessing;
import at.mrdevelopment.esl.accesspoint.UDPMessageListener;
import at.mrdevelopment.esl.accesspoint.serial.FrameInputStream;
import at.mrdevelopment.esl.accesspoint.serial.FrameOutputStream;
import at.mrdevelopment.esl.accesspoint.serial.SerialWirelessTransmitter;
import at.mrdevelopment.esl.accesspoint.serial.UartSlotReply;
import at.mrdevelopment.esl.accesspoint.serial.UartSlotRequest;
import at.mrdevelopment.esl.accesspoint.taskqueue.SlotPipeline;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;

public class UDPWirelessTransmitter
extends SerialWirelessTransmitter
implements UDPMessageListener {
    static ESLLogger logger = ESLLogger.getLogger(UDPWirelessTransmitter.class);
    private final AccessPointMessageForwarder forwarder;
    private final int apId;

    public UDPWirelessTransmitter(SlotPipeline slotPipeline, SlotPipelineProcessing pipelineProcessing, ProtocolSettingsProvider protocolSettingsProvider, int apId, AccessPointMessageForwarder forwarder, SlotIdReader slotIdReader) throws InitializationException {
        super(slotPipeline, pipelineProcessing, protocolSettingsProvider, false, slotIdReader);
        this.apId = apId;
        this.forwarder = forwarder;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    @Override
    public void receivedMessage(DatagramPacket packet, boolean toSend) throws Exception {
        FrameInputStream inputStream = new FrameInputStream(new ByteArrayInputStream(packet.getData()));
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream(477);
        FrameOutputStream outputStream = new FrameOutputStream(byteOutputStream);
        int header = inputStream.readByte();
        if (header == 174) {
            UartSlotRequest slotRequest = new UartSlotRequest(inputStream);
            UartSlotReply slotReply = new UartSlotReply(outputStream);
            this.receiveNextSlot(slotRequest, slotReply, toSend);
            if (toSend) {
                this.forwarder.forwardMessage(byteOutputStream.toByteArray(), this.apId);
            }
        }
        StreamUtils.close((OutputStream)byteOutputStream);
    }
}

