/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.core.UpdateTaskStatus;
import at.mrdevelopment.esl.type.UpdateError;

public enum TransmissionStatus {
    NO_TRANSMISSION(0),
    RUNNING(1),
    SUCCESSFUL(2),
    TRANSMISSION_FAILED(3),
    AUTH_FAILED(4),
    SKIP(5);

    private static final TransmissionStatus[] codeList;
    private final int code;

    private TransmissionStatus(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isFinished() {
        return this == SUCCESSFUL || this == TRANSMISSION_FAILED || this == AUTH_FAILED;
    }

    public boolean isSuccessful() {
        return this == SUCCESSFUL;
    }

    public boolean isFailed() {
        return this == TRANSMISSION_FAILED || this == AUTH_FAILED;
    }

    public boolean isRunning() {
        return this == RUNNING;
    }

    public boolean isNoTransmission() {
        return this == NO_TRANSMISSION;
    }

    public UpdateTaskStatus toStatus() {
        if (this == SUCCESSFUL) {
            return UpdateTaskStatus.SUCCESSFUL;
        }
        if (this == TRANSMISSION_FAILED) {
            return UpdateTaskStatus.FAILED;
        }
        return UpdateTaskStatus.ERROR;
    }

    public static TransmissionStatus fromCode(int code) throws IndexOutOfBoundsException {
        return codeList[code];
    }

    public UpdateError toError() {
        if (this == AUTH_FAILED) {
            return UpdateError.ERROR_CODE_AUTHENTICATION_FAILED;
        }
        return null;
    }

    static {
        codeList = new TransmissionStatus[TransmissionStatus.values().length];
        TransmissionStatus[] arr$ = TransmissionStatus.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            TransmissionStatus transmissionStatus;
            TransmissionStatus.codeList[transmissionStatus.getCode()] = transmissionStatus = arr$[i$];
        }
    }
}

