/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPointWakeupStatisticsListenerIF;
import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.toolkit.log.ESLLogger;
import org.joda.time.DateTime;

public class TimeoutWakeupStatisticsListenerTask
implements ESLProcessingTask {
    static ESLLogger logger = ESLLogger.getLogger(TimeoutWakeupStatisticsListenerTask.class);
    private static final int VALID_TIME_IN_MILLISECONDS = 43200000;
    private AccessPointWakeupStatisticsListenerIF wakeupStatisticsListener;
    private long lastRunTime;

    public TimeoutWakeupStatisticsListenerTask(AccessPointWakeupStatisticsListenerIF wakeupStatisticsListener) {
        this.wakeupStatisticsListener = wakeupStatisticsListener;
        this.lastRunTime = DateTime.now().getMillis();
    }

    public void run() throws Exception {
        long currentTime = DateTime.now().getMillis();
        if (currentTime - this.lastRunTime >= 43200000L) {
            this.lastRunTime = currentTime;
            if (logger.isDebugEnabled()) {
                logger.debug("Removing old entries from wakeup statistics and join requests.");
            }
            this.wakeupStatisticsListener.removeOldEntries(43200000L);
        }
    }
}

