/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPointDataListener;
import at.mrdevelopment.esl.accesspoint.RequestQueue;
import at.mrdevelopment.esl.accesspoint.request.RemoveUpdateTaskRequest;
import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;

public class TimeoutUpdateTasks
implements ESLProcessingTask {
    private static final int TASKS_VALID_MINUTES = 120;
    private final AccessPointDataListener dataListener;
    private final RequestQueue requestQueue;

    public TimeoutUpdateTasks(AccessPointDataListener dataListener, RequestQueue requestQueue) {
        this.dataListener = dataListener;
        this.requestQueue = requestQueue;
    }

    public void run() throws Exception {
        DateTime now = DateTime.now();
        List<ExternalUpdateTask> updateTasks = this.dataListener.getTimedOutUpdateTasks(now, 120);
        ArrayList<UUID> taskIds = new ArrayList<UUID>(updateTasks.size());
        for (ExternalUpdateTask eut : updateTasks) {
            taskIds.add(eut.getTaskId());
        }
        this.requestQueue.addTaskIdPartionRequests(taskIds, RemoveUpdateTaskRequest.class);
    }
}

