/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SoftSynchronizer {
    private static final ESLLogger logger = ESLLogger.getLogger(SoftSynchronizer.class);
    private final Lock lock;
    private final Condition found;
    private long lookedForIdx;
    private long currentIdx;
    private final int apId;

    public SoftSynchronizer(int apId) {
        this.apId = apId;
        this.lock = new ReentrantLock();
        this.found = this.lock.newCondition();
        this.reset();
    }

    public void reset() {
        this.lookedForIdx = -1L;
        this.currentIdx = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provide(long idx) {
        try {
            this.lock.lock();
            this.currentIdx = idx;
            if (idx >= this.lookedForIdx) {
                this.found.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void want(long targetIdx) {
        block6: {
            try {
                this.lock.lock();
                this.lookedForIdx = targetIdx;
                if (this.currentIdx >= targetIdx) break block6;
                try {
                    if (!this.found.await(750L, TimeUnit.MILLISECONDS)) {
                        logger.warn("Pipeline processing takes too long, continuing without confirmation. AP = %d!", new Object[]{this.apId});
                    }
                }
                catch (InterruptedException e) {
                    logger.logException((Throwable)e);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

