/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPoint;
import at.mrdevelopment.esl.accesspoint.AccessPointProblem;
import at.mrdevelopment.esl.accesspoint.FillSyncQueueCommand;
import at.mrdevelopment.esl.accesspoint.LabelFeatures;
import at.mrdevelopment.esl.accesspoint.PipelineProcessingCommand;
import at.mrdevelopment.esl.accesspoint.PipelineProcessingCommandType;
import at.mrdevelopment.esl.accesspoint.ReinitializePipelineCommand;
import at.mrdevelopment.esl.accesspoint.RequestAllowanceEvaluator;
import at.mrdevelopment.esl.accesspoint.SlotId;
import at.mrdevelopment.esl.accesspoint.TransmissionStatus;
import at.mrdevelopment.esl.accesspoint.command.AbstractPingCommand;
import at.mrdevelopment.esl.accesspoint.command.CommittedCommand;
import at.mrdevelopment.esl.accesspoint.command.CommittedDataCommand;
import at.mrdevelopment.esl.accesspoint.command.EmptyCommand;
import at.mrdevelopment.esl.accesspoint.command.JoinCommand;
import at.mrdevelopment.esl.accesspoint.command.SyncPacket;
import at.mrdevelopment.esl.accesspoint.command.TransmissionCommand;
import at.mrdevelopment.esl.accesspoint.command.TransmissionCommandFactory;
import at.mrdevelopment.esl.accesspoint.command.TransmissionIdProvider;
import at.mrdevelopment.esl.accesspoint.taskqueue.ImpreciseDateTimeProvider;
import at.mrdevelopment.esl.accesspoint.taskqueue.PipelinePlace;
import at.mrdevelopment.esl.accesspoint.taskqueue.ReplyQueueEntry;
import at.mrdevelopment.esl.accesspoint.taskqueue.SlotPipeline;
import at.mrdevelopment.esl.core.TransmissionInfo;
import at.mrdevelopment.esl.core.TransmissionStatistic;
import at.mrdevelopment.esl.core.UpdateTaskStatus;
import at.mrdevelopment.esl.core.security.Key;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.esl.updatetask.CommandUpdateTask;
import at.mrdevelopment.esl.updatetask.DataUpdateTask;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.updatetask.UpdateTask;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.EventPacket;
import at.mrdevelopment.esl.wireless.JoinRequest;
import at.mrdevelopment.esl.wireless.Ping;
import at.mrdevelopment.esl.wireless.Reply;
import at.mrdevelopment.esl.wireless.RxMetrics;
import at.mrdevelopment.esl.wireless.SyncProfile;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import java.util.ArrayList;
import org.joda.time.DateTime;

public class SlotPipelineProcessing
implements Shutdownable {
    static ESLLogger logger = ESLLogger.getLogger(SlotPipelineProcessing.class);
    private static final int NO_COMMAND_THRESHOLD = 10;
    private final AccessPoint accessPoint;
    private final SlotPipeline slotPipeline;
    private final TransmissionCommandFactory commandFactory = new TransmissionCommandFactory();
    private final TransmissionIdProvider transmissionIdProvider = new TransmissionIdProvider();
    private final RequestAllowanceEvaluator requestAllowanceEvaluator = RequestAllowanceEvaluator.ALLOW_JOIN_REQUESTS;
    private volatile boolean reInitializeDone;
    private volatile boolean shutdownRequested;
    private volatile boolean shutdownFinished;
    private int noCommandCounter;
    private int dateTimeProviderIdx;

    public SlotPipelineProcessing(AccessPoint accessPoint, SlotPipeline slotPipeline) {
        this.accessPoint = accessPoint;
        this.slotPipeline = slotPipeline;
        this.reInitializeDone = false;
        this.shutdownRequested = false;
        this.noCommandCounter = 0;
        this.dateTimeProviderIdx = ImpreciseDateTimeProvider.acquireIdx();
    }

    public void startProcessingThread() {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SlotPipelineProcessing.this.fillSyncQueue(SlotId.ZERO);
                    SlotPipelineProcessing.this.fillSyncQueue(new SlotId(16));
                    SlotId startSlotId = SlotId.ZERO;
                    SlotId fillSyncQueueStartSlotId = new SlotId(32);
                    while (!SlotPipelineProcessing.this.shutdownRequested) {
                        PipelineProcessingCommand command = SlotPipelineProcessing.this.slotPipeline.getCommand();
                        if (command == null) {
                            SlotPipelineProcessing.this.noCommandCounter++;
                            if (SlotPipelineProcessing.this.noCommandCounter % 10 != 0) continue;
                            SlotPipelineProcessing.this.processWebserviceRequests();
                            SlotPipelineProcessing.this.noCommandCounter = 0;
                            continue;
                        }
                        SlotPipelineProcessing.this.noCommandCounter = 0;
                        if (command.getCommandType() == PipelineProcessingCommandType.REINITIALIZE_PIPELINE) {
                            Object repliesStartSlotId = startSlotId.previous(2);
                            DateTime now = ImpreciseDateTimeProvider.get(SlotPipelineProcessing.this.dateTimeProviderIdx);
                            for (ReplyQueueEntry[] entries : command.getReplies()) {
                                try {
                                    SlotPipelineProcessing.this.processReplies((SlotId)repliesStartSlotId, entries, now);
                                }
                                catch (Exception exc) {
                                    logger.logException((Throwable)exc);
                                }
                                finally {
                                    repliesStartSlotId = ((SlotId)repliesStartSlotId).next(16);
                                }
                            }
                            startSlotId = ((ReinitializePipelineCommand)command).getSlotId();
                            logger.info("New StartSlotId = %s.", new Object[]{startSlotId});
                            repliesStartSlotId = SlotPipelineProcessing.this.slotPipeline;
                            synchronized (repliesStartSlotId) {
                                SlotPipelineProcessing.this.failAllCommandsInPipeline();
                                SlotPipelineProcessing.this.slotPipeline.clear();
                            }
                            SlotPipelineProcessing.this.fillSyncQueue(startSlotId);
                            SlotPipelineProcessing.this.fillSyncQueue(startSlotId.next(16));
                            fillSyncQueueStartSlotId = startSlotId.next(32);
                            logger.info("Reinitialized processing.");
                            SlotPipelineProcessing.this.reInitializeDone = true;
                            repliesStartSlotId = this;
                            synchronized (repliesStartSlotId) {
                                this.notifyAll();
                                continue;
                            }
                        }
                        long startTime = System.currentTimeMillis();
                        FillSyncQueueCommand queueCommand = (FillSyncQueueCommand)command;
                        if (logger.isDebugEnabled()) {
                            logger.debug("replyBatches = %d, syncBatchesToSkip = %d", new Object[]{queueCommand.getReplies().size(), queueCommand.numOfSyncBatchesToSkip()});
                        }
                        SlotId repliesStartSlotId = startSlotId.previous(2);
                        logger.debug("RepliesStartSlotId = %s.", new Object[]{repliesStartSlotId});
                        DateTime now = ImpreciseDateTimeProvider.get(SlotPipelineProcessing.this.dateTimeProviderIdx);
                        for (ReplyQueueEntry[] entries : command.getReplies()) {
                            try {
                                SlotPipelineProcessing.this.processReplies(repliesStartSlotId, entries, now);
                            }
                            catch (Exception exc) {
                                logger.logException((Throwable)exc);
                            }
                            finally {
                                repliesStartSlotId = repliesStartSlotId.next(16);
                            }
                        }
                        long ssStartTime = System.currentTimeMillis();
                        SlotPipelineProcessing.this.sendSlotTimerTicks(startSlotId);
                        logger.debug("SendSlotTimeTicks took: %d ms.", new Object[]{System.currentTimeMillis() - ssStartTime});
                        FillSyncQueueCommand syncQueueCommand = (FillSyncQueueCommand)command;
                        startSlotId = new SlotId(startSlotId.getId() + 16 * (syncQueueCommand.numOfSyncBatchesToSkip() + 1));
                        fillSyncQueueStartSlotId = new SlotId(fillSyncQueueStartSlotId.getId() + 16 * syncQueueCommand.numOfSyncBatchesToSkip());
                        SlotPipelineProcessing.this.fillSyncQueue(fillSyncQueueStartSlotId);
                        fillSyncQueueStartSlotId = new SlotId(fillSyncQueueStartSlotId.getId() + 16);
                        logger.debug("Slot reply processing and sync preperation took: %d ms.", new Object[]{System.currentTimeMillis() - startTime});
                        SlotPipelineProcessing.this.signalFillQueueCompletion(syncQueueCommand);
                        SlotPipelineProcessing.this.processNotForwardedCommands();
                    }
                    SlotPipeline slotPipeline = SlotPipelineProcessing.this.slotPipeline;
                    synchronized (slotPipeline) {
                        SlotPipelineProcessing.this.failAllCommandsInPipeline();
                    }
                    SlotPipelineProcessing.this.shutdownFinished = true;
                    logger.info("Slotpipeline Processing stopped.");
                }
                catch (Exception e) {
                    logger.logException((Throwable)e);
                }
                catch (Throwable thr) {
                    logger.logException(thr);
                }
            }
        });
        thread.setName(String.format("Slotpipeline Processing %s", this.accessPoint.getName()));
        thread.start();
    }

    private void processWebserviceRequests() {
        for (int idx = 0; idx < 16; ++idx) {
            this.accessPoint.processWebserviceRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillSyncQueue(SlotId startSlotId) {
        if (logger.isDebugEnabled()) {
            logger.debug("Preparing syncs for slots %s to %s", new Object[]{startSlotId, new SlotId(startSlotId.getId() + this.slotPipeline.getSize() - 1)});
        }
        DateTime now = ImpreciseDateTimeProvider.get(this.dateTimeProviderIdx);
        for (int index = 0; index < this.slotPipeline.getSize(); ++index) {
            SlotPipeline slotPipeline = this.slotPipeline;
            synchronized (slotPipeline) {
                SlotId slotId = new SlotId(startSlotId.getId() + index);
                SyncProfile syncProfile = this.accessPoint.getProtocolSettings().getSyncProfile();
                int blockedSlots = this.slotPipeline.getBlockedSlots();
                Address blockedLabelAddress = this.slotPipeline.getBlockedLabelAddress();
                SyncPacket syncPacket = this.buildSyncPacket(slotId, syncProfile, blockedSlots, blockedLabelAddress, now);
                this.slotPipeline.add(syncPacket);
                continue;
            }
        }
    }

    private SyncPacket buildSyncPacket(SlotId slotId, SyncProfile syncProfile, int blockedSlots, Address blockedLabelAddress, DateTime now) {
        if (slotId.isEmptySlot()) {
            return SyncPacket.createEmpty(slotId, syncProfile, 3, this.requestAllowanceEvaluator.isJoinRequestAllowed(slotId));
        }
        CommittedDataCommand<?> dataCommand = this.selectDataCommand(slotId, blockedSlots, now);
        if (dataCommand != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Scheduling data command to label %s at slot %s (%d blocked slots calculated)", new Object[]{dataCommand.getAddress(), slotId, dataCommand.getBlockedSlots(14)});
            }
            return SyncPacket.createDataInit(slotId, syncProfile, dataCommand, 3);
        }
        ArrayList<TransmissionCommand> nonDataCommands = new ArrayList<TransmissionCommand>(3);
        for (int commandSlot = 0; commandSlot < 3; ++commandSlot) {
            TransmissionCommand command = this.selectNonDataCommand(slotId, blockedLabelAddress, now);
            nonDataCommands.add(commandSlot, command);
        }
        return SyncPacket.createCommandList(slotId, syncProfile, nonDataCommands, this.requestAllowanceEvaluator.isJoinRequestAllowed(slotId));
    }

    private CommittedDataCommand<?> selectDataCommand(SlotId slotId, int blockedSlots, DateTime now) {
        if (blockedSlots > 0) {
            return null;
        }
        CommittedDataCommand<?> dataCommand = this.queryDataCommand(slotId, TaskPriority.HIGH, now);
        if (dataCommand == null) {
            dataCommand = this.queryDataCommand(slotId, TaskPriority.NORMAL, now);
        }
        if (dataCommand == null) {
            dataCommand = this.queryDataCommand(slotId, TaskPriority.LOW, now);
        }
        return dataCommand;
    }

    private TransmissionCommand selectNonDataCommand(SlotId slotId, Address blockedLabelAddress, DateTime now) {
        TransmissionCommand command = this.queryCommand(slotId, TaskPriority.JOIN, blockedLabelAddress, now);
        if (command == null) {
            command = this.queryCommand(slotId, TaskPriority.HIGH, blockedLabelAddress, now);
        }
        if (command == null) {
            command = this.queryCommand(slotId, TaskPriority.NORMAL, blockedLabelAddress, now);
        }
        if (command == null) {
            command = this.queryCommand(slotId, TaskPriority.LOW, blockedLabelAddress, now);
        }
        if (command == null) {
            command = this.queryCommand(slotId, TaskPriority.PING, blockedLabelAddress, now);
        }
        return command != null ? command : EmptyCommand.INSTANCE;
    }

    private CommittedDataCommand<?> queryDataCommand(SlotId slotId, TaskPriority priority, DateTime now) {
        DataUpdateTask updateTask = this.accessPoint.queryDataUpdateTask(slotId, priority, now);
        if (updateTask != null) {
            LabelFeatures labelFeatures = this.accessPoint.getLabelFeatures(updateTask.getAddress());
            int dataTransmissionId = 0;
            if (labelFeatures.isImprovedDataPacket()) {
                dataTransmissionId = this.transmissionIdProvider.getNextTransmissionId();
            }
            Key key = this.accessPoint.getKeyForUpdateTask(updateTask);
            return this.commandFactory.toDataCommand(updateTask, key, this.accessPoint.getTransmissionSettings(updateTask.getAddress()), dataTransmissionId);
        }
        return null;
    }

    private TransmissionCommand queryCommand(SlotId slotId, TaskPriority priority, Address blockedLabelAddress, DateTime now) {
        CommandUpdateTask updateTask = this.accessPoint.queryCommandUpdateTask(slotId, priority, blockedLabelAddress, now);
        return updateTask != null ? this.commandFactory.toCommand(updateTask, this.accessPoint.getProtocolSettings().getUsedChannels()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReplies(SlotId startSlotId, ReplyQueueEntry[] replies, DateTime now) throws IOException {
        logger.info("Processing replies for slots %s to %s", new Object[]{startSlotId, new SlotId(startSlotId.getId() + this.slotPipeline.getSize() - 1)});
        for (int index = 0; index < this.slotPipeline.getSize(); ++index) {
            SlotPipeline slotPipeline = this.slotPipeline;
            synchronized (slotPipeline) {
                SlotId slotId = new SlotId(startSlotId.getId() + index);
                SyncPacket syncPacket = this.slotPipeline.getSyncOnly(slotId);
                ReplyQueueEntry entry = replies[slotId.getId() % replies.length];
                if (syncPacket != null) {
                    if (!slotId.equals(syncPacket.getSlotId())) {
                        logger.warn("Sync queue slot mismatch (expected=%s, actual=%s)", new Object[]{slotId, syncPacket.getSlotId()});
                        if (entry != null) {
                            this.processUpdateStatus(entry, now);
                        }
                        this.failAllCommands(syncPacket, UpdateError.ERROR_CODE_TRANSMITTER_COMMUNICATION, now);
                    } else if (entry != null) {
                        if (!slotId.equals(entry.getSlotId())) {
                            logger.info("Reply queue slot mismatch (expected=%s, actual=%s)", new Object[]{slotId, entry.getSlotId()});
                            this.processUpdateStatus(entry, now);
                            this.failAllCommands(syncPacket, UpdateError.ERROR_CODE_TRANSMITTER_COMMUNICATION, now);
                        } else {
                            try {
                                this.processReplies(slotId, syncPacket, entry, now);
                            }
                            catch (Exception e) {
                                logger.logException((Throwable)e);
                            }
                        }
                    } else {
                        logger.info("No ReplyQueueEntry for slot = %s.", new Object[]{slotId});
                        this.failAllCommands(syncPacket, UpdateError.ERROR_CODE_TRANSMITTER_COMMUNICATION, now);
                    }
                } else if (entry != null) {
                    logger.info("There was a ReplyQueueEntry (%s) with no matching sync packet. Processing status.", new Object[]{entry.getSlotId()});
                    this.processUpdateStatus(entry, now);
                } else {
                    logger.info("No SyncPacket and no ReplyQueueEntry for slot = %s.", new Object[]{slotId});
                }
                this.slotPipeline.removeSync(slotId);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNotForwardedCommands() {
        DateTime now = DateTime.now();
        SlotPipeline slotPipeline = this.slotPipeline;
        synchronized (slotPipeline) {
            for (SyncPacket sync : this.slotPipeline.getAndRemoveNotForwarded()) {
                this.failAllCommands(sync, UpdateError.ERROR_CODE_TASK_NOT_PREPARED, now);
            }
        }
    }

    private void processReplies(SlotId slotId, SyncPacket syncPacket, ReplyQueueEntry entry, DateTime now) throws IOException {
        this.processUpdateStatus(entry, now);
        for (int replySlot = 0; replySlot < 3; ++replySlot) {
            TransmissionCommand command = syncPacket.getCommand(replySlot);
            Reply reply = entry.getReply(replySlot);
            if (logger.isDebugEnabled() && command instanceof JoinCommand) {
                logger.debug("Processing reply for join command from label %s - S: %s, SS: %s, RQES: %s.", new Object[]{((JoinCommand)command).getAddress().toString(), slotId.toString(), syncPacket.getSlotId().toString(), entry.getSlotId().toString()});
            }
            this.processReply(slotId, reply, command, false, now);
        }
        for (int joinSlot = 0; joinSlot < 5; ++joinSlot) {
            JoinRequest joinRequest = entry.getJoinRequest(joinSlot);
            this.processJoinRequest(joinRequest, now);
        }
        for (int eventSlot = 0; eventSlot < 5; ++eventSlot) {
            EventPacket event = entry.getEvent(eventSlot);
            this.processEvent(event, now);
        }
        if (entry.hasUartError()) {
            this.accessPoint.uartError();
        }
        for (AccessPointProblem problem : entry.getProblems()) {
            this.accessPoint.reportProblem(problem);
        }
        int usedSyncCommands = this.getUsedSyncCommandCount(syncPacket);
        int usedPacketSlots = entry.getTransmissionStatus().isRunning() ? 14 : 0;
        this.accessPoint.updateUtilizations(usedSyncCommands, entry.getJoinRequestCount(), entry.getEventCount(), usedPacketSlots, entry.isPipelineHazard(), entry.getTransmissionStatus().isFinished());
    }

    private int getUsedSyncCommandCount(SyncPacket syncPacket) {
        if (syncPacket.getCommandType().isCommandList() || syncPacket.getCommandType().isData()) {
            return syncPacket.getNonEmptyCommandCount();
        }
        if (syncPacket.getCommandType().isDataInit()) {
            return 3;
        }
        return 0;
    }

    private boolean processReply(SlotId slotId, Reply reply, TransmissionCommand command, boolean uartReplyError, DateTime now) throws IOException {
        if (command == null) {
            logger.warn("Slot %s, reply %d: Command not found", new Object[]{slotId, reply.getReplySlot()});
            return false;
        }
        if (reply == null) {
            if (logger.isDebugEnabled() && !(command instanceof EmptyCommand)) {
                logger.debug("Slot %s: No reply for command to label %s received", new Object[]{slotId, command.getAddress()});
            }
            this.failNonDataCommand(command, (UpdateError)(uartReplyError ? UpdateError.ERROR_CODE_TRANSMITTER_COMMUNICATION : null), now);
            return false;
        }
        if (!command.getAddress().equals((Object)reply.getSenderAddress())) {
            logger.warn("Slot %s, reply %d: Command and reply label addresses do not match (command=%s, reply=%s)", new Object[]{slotId, reply.getReplySlot(), command.getAddress(), reply.getSenderAddress()});
            this.failNonDataCommand(command, UpdateError.ERROR_CODE_TRANSMITTER_COMMUNICATION, now);
            return false;
        }
        if (command.getCommandId() != reply.getCommandId()) {
            logger.warn("Slot %s, reply %d: Command and reply command ID do not match (command=%d, reply=%d)", new Object[]{slotId, reply.getReplySlot(), command.getCommandId(), reply.getCommandId()});
            this.failNonDataCommand(command, UpdateError.ERROR_CODE_TRANSMITTER_COMMUNICATION, now);
            return false;
        }
        if (command instanceof CommittedCommand) {
            CommittedCommand committedCommand = (CommittedCommand)command;
            this.commitCommand(committedCommand, reply, now);
        } else {
            logger.warn("Slot %s, reply %d: Received unknown command reply with ID %d from %s with ack=%b", new Object[]{slotId, reply.getReplySlot(), reply.getCommandId(), reply.getSenderAddress(), reply.isAcknowledged()});
        }
        return true;
    }

    private void commitCommand(CommittedCommand<?> command, Reply reply, DateTime now) throws IOException {
        Ping ping;
        UpdateError updateError;
        command.readReply(reply);
        boolean acknowledge = reply.isAcknowledged();
        RxMetrics rxMetrics = reply.getRxMetrics();
        TransmissionStatistic transmissionStatistic = TransmissionStatistic.full((int)rxMetrics.getRssi(), (int)rxMetrics.getLqi(), (int)59);
        UpdateTaskStatus status = acknowledge ? UpdateTaskStatus.SUCCESSFUL : UpdateTaskStatus.ERROR;
        UpdateError updateError2 = updateError = acknowledge ? null : UpdateError.ERROR_CODE_NO_ACKNOWLEDGE;
        if (command instanceof AbstractPingCommand && (ping = ((AbstractPingCommand)command).getPing()) != null) {
            this.accessPoint.processPing(command.getAddress(), ping, rxMetrics);
        }
        if (logger.isDebugEnabled() && command instanceof JoinCommand) {
            logger.debug("Got join reply from: %s.", new Object[]{reply.getSenderAddress().toString()});
        }
        this.accessPoint.labelUpdateFinished((UpdateTask)command.getUpdateTask(), status, updateError, transmissionStatistic, now);
    }

    private void failAllCommands(SyncPacket syncPacket, UpdateError updateError, DateTime now) {
        this.failDataCommand(syncPacket.getDataCommand(), updateError, now);
        for (TransmissionCommand transmissionCommand : syncPacket.getNonEmptyCommands()) {
            this.failNonDataCommand(transmissionCommand, updateError, now);
        }
    }

    private void failDataCommand(CommittedDataCommand<?> dataCommand, UpdateError updateError, DateTime now) {
        if (dataCommand != null) {
            this.slotPipeline.getAndRemoveDataCommand(dataCommand.getId());
            this.failCommand((UpdateTask)dataCommand.getUpdateTask(), updateError, now);
        }
    }

    private void failNonDataCommand(TransmissionCommand command, UpdateError updateError, DateTime now) {
        if (command instanceof CommittedCommand) {
            CommittedCommand committedCommand = (CommittedCommand)command;
            this.failCommand((UpdateTask)committedCommand.getUpdateTask(), updateError, now);
        }
    }

    private void failCommand(UpdateTask updateTask, UpdateError updateError, DateTime now) {
        TransmissionStatistic transmissionStatistic = TransmissionStatistic.timeOnly((int)59);
        UpdateTaskStatus status = updateError != null ? UpdateTaskStatus.ERROR : UpdateTaskStatus.FAILED;
        this.accessPoint.labelUpdateFinished(updateTask, status, updateError, transmissionStatistic, now);
    }

    private void processJoinRequest(JoinRequest joinRequest, DateTime now) {
        if (joinRequest != null) {
            this.accessPoint.joinRequested(joinRequest.getSenderAddress(), now);
        }
    }

    private void processEvent(EventPacket event, DateTime now) {
        if (event != null) {
            this.accessPoint.eventReceived(event.getSenderAddress(), event.getEventType(), event.getEventData(), now);
        }
    }

    private void processUpdateStatus(ReplyQueueEntry entry, DateTime now) {
        SlotId slotId = entry.getSlotId();
        if (entry.isErrorCommandSet()) {
            CommittedDataCommand<?> dataCommand = this.slotPipeline.getAndRemoveDataCommand(entry.getErrorCommandId());
            if (dataCommand != null) {
                TransmissionInfo transmissionInfo = new TransmissionInfo(new RxMetrics(0, 0), new RxMetrics(0, 0), 0);
                TransmissionStatistic transmissionStatistic = TransmissionStatistic.fromTransmissionInfo((TransmissionInfo)transmissionInfo, (int)0);
                logger.info("%s detected at slot %s for label %s.", new Object[]{entry.getErrorType().name(), slotId, dataCommand.getAddress()});
                this.accessPoint.labelUpdateFinished((UpdateTask)dataCommand.getUpdateTask(), UpdateTaskStatus.ERROR, entry.getUpdateError(), transmissionStatistic, now);
            } else {
                logger.error("Processing reply update status[%s], no data command available.", new Object[]{entry.getErrorType().name()});
            }
        }
        if (entry.getExpectedCommandId() != null) {
            Object updateTask;
            CommittedDataCommand<?> dataCommand;
            TransmissionStatus transmissionStatus = entry.getTransmissionStatus();
            if (transmissionStatus.isFinished()) {
                dataCommand = this.slotPipeline.getAndRemoveDataCommand(entry.getExpectedCommandId());
                if (dataCommand != null) {
                    updateTask = dataCommand.getUpdateTask();
                    UpdateTaskStatus status = transmissionStatus.toStatus();
                    UpdateError updateError = transmissionStatus.toError();
                    TransmissionInfo transmissionInfo = entry.getTransmissionInfo();
                    int transmissionTime = entry.getTransmissionSlots() * 59;
                    TransmissionStatistic transmissionStatistic = TransmissionStatistic.fromTransmissionInfo((TransmissionInfo)transmissionInfo, (int)transmissionTime);
                    if (logger.isDebugEnabled()) {
                        logger.debug("%s to label %s finished with status %s at slot %s.", new Object[]{updateTask.getClass().getSimpleName(), updateTask.getAddress(), status, slotId});
                    }
                    logger.info("Estimated slots: %d, actual slots: %d.", new Object[]{dataCommand.getBlockedSlots(14), entry.getTransmissionSlots()});
                    this.accessPoint.labelUpdateFinished((UpdateTask)updateTask, status, updateError, transmissionStatistic, now);
                } else {
                    logger.error("Processing reply update status[FINISHED], no data command available.");
                }
            } else if (transmissionStatus.isNoTransmission()) {
                dataCommand = this.slotPipeline.getAndRemoveDataCommand(entry.getExpectedCommandId());
                if (dataCommand != null) {
                    updateTask = dataCommand.getUpdateTask();
                    int transmissionTime = entry.getTransmissionSlots() * 59;
                    TransmissionStatistic transmissionStatistic = TransmissionStatistic.timeOnly((int)transmissionTime);
                    logger.warn("Missed update status for label %s at slot %s.", new Object[]{updateTask.getAddress(), slotId});
                    this.accessPoint.labelUpdateFinished((UpdateTask)updateTask, UpdateTaskStatus.ERROR, UpdateError.ERROR_CODE_TRANSMITTER_COMMUNICATION, transmissionStatistic, now);
                } else {
                    logger.error("Processing reply update status[NO_TRANSMISSION], no data command available.");
                }
            }
        }
    }

    private void sendSlotTimerTicks(SlotId startSlotId) {
        DateTime now = DateTime.now();
        for (int index = 0; index < this.slotPipeline.getSize(); ++index) {
            SlotId slotId = new SlotId(startSlotId.getId() + index);
            this.accessPoint.slotTimerTick(slotId, now);
        }
    }

    public void shutdown() {
        this.shutdownRequested = true;
        this.slotPipeline.breakGetCommand();
        while (!this.shutdownFinished) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.info("Slot pipeline processing terminated");
    }

    private void failAllCommandsInPipeline() {
        DateTime now = DateTime.now();
        for (PipelinePlace pipelinePlace : this.slotPipeline.getAllPipelinePlaces()) {
            if (pipelinePlace.getCurrentPacket() == null) continue;
            this.failAllCommands(pipelinePlace.getCurrentPacket(), UpdateError.ERROR_CODE_TRANSMITTER_COMMUNICATION, now);
        }
        for (CommittedDataCommand committedDataCommand : this.slotPipeline.getAndRemoveAllDataCommands()) {
            this.failDataCommand(committedDataCommand, UpdateError.ERROR_CODE_TRANSMITTER_COMMUNICATION, now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reInitializeAndWait(SlotId slotId) {
        this.reInitializeDone = false;
        this.slotPipeline.putReinitializeOnQueue(slotId);
        SlotPipelineProcessing slotPipelineProcessing = this;
        synchronized (slotPipelineProcessing) {
            while (!this.shutdownRequested && !this.reInitializeDone) {
                try {
                    this.wait(2L);
                }
                catch (InterruptedException ie) {
                    logger.logException((Throwable)ie);
                }
            }
        }
    }

    public static SlotId calculateStartSlotId(SlotId id) {
        int newSlotId = id.getId() - id.getId() % 16;
        return new SlotId(newSlotId);
    }

    protected void signalFillQueueCompletion(FillSyncQueueCommand command) {
    }
}

