/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.DefaultSlotIdReader;
import at.mrdevelopment.esl.accesspoint.LegacySlotIdReader;
import at.mrdevelopment.esl.accesspoint.SlotId;
import at.mrdevelopment.esl.accesspoint.SlotIdReader;
import at.mrdevelopment.esl.accesspoint.command.SyncPacket;
import at.mrdevelopment.esl.accesspoint.serial.FrameInputStream;
import at.mrdevelopment.toolkit.FirmwareVersionProvider;
import at.mrdevelopment.toolkit.Version;
import java.io.IOException;

public class SlotIdReaderStrategy
implements SlotIdReader {
    private static final Version LEGACY_VERSION = Version.fromString((String)"3.0.3");
    private final FirmwareVersionProvider fmVersionProvider;
    private final DefaultSlotIdReader defaultReader = new DefaultSlotIdReader();
    private final LegacySlotIdReader legacyReader = new LegacySlotIdReader();

    public SlotIdReaderStrategy(FirmwareVersionProvider fmVersionProvider) {
        this.fmVersionProvider = fmVersionProvider;
    }

    @Override
    public int readRawSlotId(FrameInputStream inputStream) throws IOException {
        return this.getReaderForVersion(this.fmVersionProvider.getFirmwareVersion()).readRawSlotId(inputStream);
    }

    @Override
    public SlotId getSlotId(int rawSlotId) {
        return this.getReaderForVersion(this.fmVersionProvider.getFirmwareVersion()).getSlotId(rawSlotId);
    }

    @Override
    public int getSlotInfoWord(int rawSlotId, SyncPacket syncPacket) {
        return this.getReaderForVersion(this.fmVersionProvider.getFirmwareVersion()).getSlotInfoWord(rawSlotId, syncPacket);
    }

    @Override
    public int getSlotInfoWordForThinAp(int slotId, SyncPacket syncPacket) {
        return this.getReaderForVersion(this.fmVersionProvider.getFirmwareVersion()).getSlotInfoWordForThinAp(slotId, syncPacket);
    }

    @Override
    public int getSlotInfoWordForEmptySync(int syncProfileId) {
        return this.getReaderForVersion(this.fmVersionProvider.getFirmwareVersion()).getSlotInfoWordForEmptySync(syncProfileId);
    }

    @Override
    public int getSlotIdForThinAp(int slotId) {
        return this.getReaderForVersion(this.fmVersionProvider.getFirmwareVersion()).getSlotIdForThinAp(slotId);
    }

    private SlotIdReader getReaderForVersion(Version version) {
        if (version != null && version.isEqualOlder(LEGACY_VERSION)) {
            return this.legacyReader;
        }
        this.legacyReader.reset();
        return this.defaultReader;
    }
}

