/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import com.google.common.base.Objects;

public class SlotId {
    public static final SlotId ZERO = new SlotId(0);
    private final int slotId;

    public SlotId(int slotId) {
        this.slotId = (slotId + 1024) % 1024;
    }

    public int getId() {
        return this.slotId;
    }

    public SlotId next(int step) {
        return new SlotId(this.slotId + step);
    }

    public SlotId previous(int step) {
        return new SlotId(this.slotId - step);
    }

    public SlotId next() {
        return this.next(1);
    }

    public SlotId forReply() {
        return this.previous(2);
    }

    public boolean isOne() {
        return this.slotId == 1;
    }

    public boolean isNextOf(SlotId previousCandidate) {
        return this.slotId == (previousCandidate.slotId + 1) % 1024;
    }

    public int differenceTo(SlotId target) {
        if (this.slotId < target.slotId) {
            return target.slotId - this.slotId;
        }
        return target.slotId + 1024 - this.slotId;
    }

    public boolean isEmptySlot() {
        return (this.slotId & 0xFF) == 255;
    }

    public boolean isCycleStart() {
        return this.slotId == 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.slotId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SlotId other = (SlotId)obj;
        return this.slotId == other.slotId;
    }

    public String toString() {
        return String.format("%03X (%d)", this.slotId, this.slotId);
    }
}

