/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.AccessPointCommonDataListener;
import at.mrdevelopment.esl.accesspoint.AccessPointRuntimeConfiguration;
import at.mrdevelopment.esl.admin.AccessPointConfigurationXMLSerializer;
import at.mrdevelopment.esl.admin.platform.SystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.BroadcastConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.BroadcastMessage;
import at.mrdevelopment.esl.admin.platform.config.manager.AccessPointConfigurationManager;
import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import javax.xml.transform.TransformerException;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;

public class SendBroadcastTask
implements ESLProcessingTask {
    static ESLLogger logger = ESLLogger.getLogger(SendBroadcastTask.class);
    private static final Version BROADCAST_VERSION = Version.fromString((String)"1.0.0");
    private final AccessPointCommonDataListener accessPointDataListener;
    private final AccessPointConfigurationManager configurationManager;
    private final SystemAttributes systemAttributes;
    private final AccessPointRuntimeConfiguration runtimeConfiguration;
    private final AccessPointConfigurationXMLSerializer xmlAccessPointConfiguration;
    private DateTime lastBroadcastTime = null;

    public SendBroadcastTask(AccessPointCommonDataListener accessPointDataListener, AccessPointConfigurationManager configurationManager, SystemAttributes systemAttributes, AccessPointRuntimeConfiguration runtimeConfiguration) throws InitializationException {
        this.accessPointDataListener = accessPointDataListener;
        this.configurationManager = configurationManager;
        this.systemAttributes = systemAttributes;
        this.runtimeConfiguration = runtimeConfiguration;
        this.xmlAccessPointConfiguration = new AccessPointConfigurationXMLSerializer();
    }

    public void run() throws Exception {
        logger.debug("Running SendBroadcastTask");
        DateTime now = DateTime.now();
        BroadcastConfiguration broadcastConfiguration = this.configurationManager.getBroadcastConfiguration();
        if (broadcastConfiguration.isBroadcastEnabled() && (this.lastBroadcastTime == null || this.runtimeConfiguration.isForceBroadcast() || Minutes.minutesBetween((ReadableInstant)this.lastBroadcastTime, (ReadableInstant)now).getMinutes() >= broadcastConfiguration.getTimeIntervalInMinutes())) {
            this.sendBroadcast();
            this.lastBroadcastTime = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBroadcast() {
        DatagramSocket datagramSocket = null;
        try {
            String broadcastAddress = this.getBroadcastAddress();
            int port = this.configurationManager.getBroadcastConfiguration().getBroadcastPort();
            logger.info("Sending discovery broadcast to %s:%d", new Object[]{broadcastAddress, port});
            datagramSocket = new DatagramSocket();
            datagramSocket.setSoTimeout(3000);
            datagramSocket.setBroadcast(true);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(new BufferedOutputStream(byteStream));
            try {
                objectStream.writeObject(this.createBroadcastMessage());
                objectStream.flush();
                byte[] sendBuf = byteStream.toByteArray();
                DatagramPacket sendPacket = new DatagramPacket(sendBuf, sendBuf.length, new InetSocketAddress(broadcastAddress, port));
                datagramSocket.send(sendPacket);
            }
            finally {
                objectStream.close();
            }
        }
        catch (Exception exc) {
            logger.error("Failed to send broadcast");
            logger.logException((Throwable)exc);
        }
        finally {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
        }
        this.runtimeConfiguration.resetForceBroadcast();
    }

    private String getBroadcastAddress() throws Exception {
        return this.accessPointDataListener.getEnvironmentProperties().getBroadcast();
    }

    private String createBroadcastMessage() throws TransformerException {
        BroadcastMessage message = new BroadcastMessage(this.systemAttributes.getId(), this.configurationManager.getAutoConfiguration().isEnabled().booleanValue(), BROADCAST_VERSION, this.configurationManager.getWebserviceConfiguration().isDefaultServicePortSSL(), this.runtimeConfiguration.getPort());
        return this.xmlAccessPointConfiguration.toString(this.xmlAccessPointConfiguration.toBroadcastMessageXML(message));
    }
}

