/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.request.ClearRoamingTableRequest;
import at.mrdevelopment.esl.accesspoint.request.SetRoamingTableRequest;
import at.mrdevelopment.esl.accesspoint.request.WebserviceExecutionRequest;
import at.mrdevelopment.esl.core.UpdateTaskQueueListener;
import at.mrdevelopment.esl.core.UpdateTaskQueueNotifier;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import at.mrdevelopment.toolkit.collection.PartitionedListIterator;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.joda.time.DateTime;

public class RequestQueue
implements UpdateTaskQueueNotifier {
    static ESLLogger logger = ESLLogger.getLogger(RequestQueue.class);
    private static final int UPDATE_TASK_REQUEST_PARTION_SIZE = 25;
    private static final int TASK_ID_REQUEST_PARTION_SIZE = 1000;
    private final Queue<WebserviceExecutionRequest> requests = new LinkedList<WebserviceExecutionRequest>();
    private WebserviceExecutionRequest roamingTableRequest = null;
    private int validTimeInMinutes = 0;
    private DateTime lastReceiveTime = null;
    private List<UpdateTaskQueueListener> updateTaskQueueListeners = new CopyOnWriteArrayList<UpdateTaskQueueListener>();

    public synchronized boolean isRoamingTableValid() {
        if (this.lastReceiveTime != null) {
            return this.lastReceiveTime.plusMinutes(this.validTimeInMinutes).isAfterNow();
        }
        return false;
    }

    public synchronized void addUpdateTaskPartionRequests(List<ExternalUpdateTask> updateTasks, Class<? extends WebserviceExecutionRequest> type) {
        try {
            Iterable listPartitions = PartitionedListIterator.createPartitions(updateTasks, (int)25);
            Constructor<? extends WebserviceExecutionRequest> constructor = type.getConstructor(Collection.class);
            for (List partition : listPartitions) {
                WebserviceExecutionRequest request = constructor.newInstance(partition);
                this.requests.offer(request);
                this.notifyUpdateTasksQueued(partition);
            }
        }
        catch (InstantiationException exc) {
            logger.logException((Throwable)exc);
            throw new RuntimeException(exc);
        }
        catch (IllegalAccessException exc) {
            logger.logException((Throwable)exc);
            throw new RuntimeException(exc);
        }
        catch (InvocationTargetException exc) {
            logger.logException((Throwable)exc);
            throw new RuntimeException(exc);
        }
        catch (NoSuchMethodException exc) {
            logger.logException((Throwable)exc);
            throw new RuntimeException(exc);
        }
    }

    public synchronized void addTaskIdPartionRequests(List<UUID> taskIds, Class<? extends WebserviceExecutionRequest> type) {
        try {
            Iterable listPartitions = PartitionedListIterator.createPartitions(taskIds, (int)1000);
            Constructor<? extends WebserviceExecutionRequest> constructor = type.getConstructor(Collection.class);
            for (List partition : listPartitions) {
                WebserviceExecutionRequest request = constructor.newInstance(partition);
                this.requests.offer(request);
            }
        }
        catch (InstantiationException exc) {
            logger.logException((Throwable)exc);
            throw new RuntimeException(exc);
        }
        catch (IllegalAccessException exc) {
            logger.logException((Throwable)exc);
            throw new RuntimeException(exc);
        }
        catch (InvocationTargetException exc) {
            logger.logException((Throwable)exc);
            throw new RuntimeException(exc);
        }
        catch (NoSuchMethodException exc) {
            logger.logException((Throwable)exc);
            throw new RuntimeException(exc);
        }
    }

    public synchronized void addRequest(WebserviceExecutionRequest request) {
        if (request instanceof SetRoamingTableRequest) {
            this.roamingTableRequest = request;
            this.validTimeInMinutes = ((SetRoamingTableRequest)request).getRoamingTable().getValidTimeInMinutes();
            this.lastReceiveTime = DateTime.now();
        } else if (request instanceof ClearRoamingTableRequest) {
            this.roamingTableRequest = request;
        } else {
            this.requests.offer(request);
        }
    }

    public synchronized WebserviceExecutionRequest getRequest() {
        if (this.roamingTableRequest != null) {
            WebserviceExecutionRequest newRequest = this.roamingTableRequest;
            this.roamingTableRequest = null;
            return newRequest;
        }
        return this.requests.poll();
    }

    private void notifyUpdateTasksQueued(List<ExternalUpdateTask> tasks) {
        for (UpdateTaskQueueListener listener : this.updateTaskQueueListeners) {
            listener.updateTasksAddedToRequestQueue(tasks);
        }
    }

    public void registerUpdateTaskQueueListener(UpdateTaskQueueListener listener) {
        this.updateTaskQueueListeners.add(listener);
    }

    public void unregisterUpdateTaskQueueListener(UpdateTaskQueueListener listener) {
        this.updateTaskQueueListeners.remove(listener);
    }
}

