/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.FillSyncQueueCommand;
import at.mrdevelopment.esl.accesspoint.PipelineProcessingCommand;
import at.mrdevelopment.esl.accesspoint.PipelineProcessingCommandType;
import at.mrdevelopment.esl.accesspoint.ReinitializePipelineCommand;
import at.mrdevelopment.esl.accesspoint.taskqueue.ReplyQueueEntry;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PipelineProcessingQueue {
    private static ESLLogger logger = ESLLogger.getLogger(PipelineProcessingQueue.class);
    private final Lock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Deque<PipelineProcessingCommand> deque = new LinkedList<PipelineProcessingCommand>();

    private void addTo(PipelineProcessingCommand ppc, LinkedList<ReplyQueueEntry[]> newEntries) {
        for (ReplyQueueEntry[] currentEntry : ppc.getReplies()) {
            if (newEntries.size() >= 4) continue;
            newEntries.add(currentEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putOnQueue(PipelineProcessingCommand command) {
        if (command.getCommandType() == PipelineProcessingCommandType.REINITIALIZE_PIPELINE) {
            try {
                LinkedList<ReplyQueueEntry[]> newEntries = new LinkedList<ReplyQueueEntry[]>();
                this.lock.lock();
                for (PipelineProcessingCommand ppc : this.deque) {
                    this.addTo(ppc, newEntries);
                }
                this.addTo(command, newEntries);
                ((ReinitializePipelineCommand)command).resetReplyEntries(newEntries);
                this.deque.clear();
                this.deque.offerLast(command);
                this.notEmpty.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
        try {
            this.lock.lock();
            PipelineProcessingCommand lastCommand = this.deque.peekLast();
            if (lastCommand != null) {
                if (lastCommand.getCommandType() == PipelineProcessingCommandType.FILL_SYNC_QUEUE) {
                    FillSyncQueueCommand tempCommand = (FillSyncQueueCommand)lastCommand;
                    tempCommand.skipAdditionalSyncBatch(((FillSyncQueueCommand)command).getReplies().get(0));
                } else {
                    this.deque.offerLast(command);
                }
            } else {
                this.deque.offerLast(command);
            }
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PipelineProcessingCommand getCommand() {
        PipelineProcessingCommand tempCommand;
        block6: {
            tempCommand = null;
            try {
                this.lock.lock();
                tempCommand = this.deque.pollFirst();
                if (tempCommand != null) break block6;
                try {
                    if (this.notEmpty.await(120L, TimeUnit.MILLISECONDS)) {
                        tempCommand = this.deque.pollFirst();
                    }
                }
                catch (InterruptedException ie) {
                    logger.logException((Throwable)ie);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return tempCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeGetCommand() {
        try {
            this.lock.lock();
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }
}

