/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.SlotId;
import at.mrdevelopment.esl.accesspoint.SlotIdReader;
import at.mrdevelopment.esl.accesspoint.command.SyncPacket;
import at.mrdevelopment.esl.accesspoint.serial.FrameInputStream;
import java.io.IOException;

public class LegacySlotIdReader
implements SlotIdReader {
    private static final int LEGACY_SLOT_COUNT = 256;
    private int multiplier = 0;
    private int lastRequestedSlotId = -1;
    private boolean updateMultiplier = false;

    @Override
    public int readRawSlotId(FrameInputStream inputStream) throws IOException {
        return inputStream.readWord();
    }

    @Override
    public SlotId getSlotId(int rawSlotId) {
        if (this.lastRequestedSlotId >= 0) {
            while (rawSlotId != (this.lastRequestedSlotId + 1) % 256) {
                this.lastRequestedSlotId = (this.lastRequestedSlotId + 1) % 256;
                this.updateMultiplier(this.lastRequestedSlotId);
            }
            this.updateMultiplier(rawSlotId);
        }
        this.lastRequestedSlotId = rawSlotId;
        return new SlotId(rawSlotId + 256 * this.multiplier);
    }

    private void updateMultiplier(int newSlotId) {
        if (this.updateMultiplier) {
            ++this.multiplier;
            this.multiplier %= 4;
            this.updateMultiplier = false;
        }
        this.updateMultiplier = newSlotId == 255;
    }

    @Override
    public int getSlotInfoWord(int rawSlotId, SyncPacket syncPacket) {
        return rawSlotId;
    }

    @Override
    public int getSlotInfoWordForThinAp(int slotId, SyncPacket syncPacket) {
        return slotId & 0xFF;
    }

    @Override
    public int getSlotInfoWordForEmptySync(int syncProfileId) {
        return 0;
    }

    @Override
    public int getSlotIdForThinAp(int slotId) {
        return slotId & 0xFF;
    }

    public void reset() {
        this.multiplier = 0;
        this.lastRequestedSlotId = -1;
        this.updateMultiplier = false;
    }
}

