/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.core.labeltype.LabelTypeMapping;
import gnu.trove.map.hash.TIntObjectHashMap;

public class LegacyLabelTypeMapping
implements LabelTypeMapping {
    private final TIntObjectHashMap<LabelType> labelTypeMapping = new TIntObjectHashMap();

    public LegacyLabelTypeMapping() {
        this.add(23, LabelType.DISPLAY_RAIL_DEMO_132_SMALL);
        this.add(24, LabelType.DISPLAY_RAIL_DEMO_132_MEDIUM);
        this.add(25, LabelType.DISPLAY_RAIL_DEMO_132_LARGE);
        this.add(26, LabelType.TESTBOX_270);
        this.add(29, LabelType.BATTERY_SEGMENTED);
        this.add(30, LabelType.BATTERY_SEGMENTED);
        this.add(31, LabelType.BATTERY_SEGMENTED);
        this.add(161, LabelType.BATTERY_200);
        this.add(162, LabelType.BATTERY_200_FLIPPED);
        this.add(164, LabelType.BOSSARD);
        this.add(165, LabelType.BATTERY_220_RED);
        this.add(166, LabelType.BATTERY_220);
        this.add(167, LabelType.BATTERY_220_BWY);
        this.add(177, LabelType.BATTERY_270_FLIPPED);
        this.add(178, LabelType.BATTERY_270);
        this.add(179, LabelType.BATTERY_270);
        this.add(180, LabelType.G1_0270_BW_270);
        this.add(181, LabelType.BATTERY_270_RED);
        this.add(182, LabelType.BATTERY_260_RED);
        this.add(183, LabelType.BATTERY_260);
        this.add(184, LabelType.BATTERY_260_BWY);
        this.add(185, LabelType.BATTERY_270_BWY);
        this.add(186, LabelType.G1_0260_BW_090);
        this.add(187, LabelType.G1_0260_BWR_090);
        this.add(188, LabelType.G1_0260_BWY_090);
        this.add(189, LabelType.G1_0270_BWR_090);
        this.add(190, LabelType.BATTERY_290_RED);
        this.add(191, LabelType.G1_0260_BWR_090);
        this.add(193, LabelType.BATTERY_441);
        this.add(196, LabelType.BATTERY_441_RED);
        this.add(197, LabelType.BATTERY_420_RED);
        this.add(198, LabelType.BATTERY_450_RED);
        this.add(199, LabelType.BATTERY_420);
        this.add(200, LabelType.BATTERY_450);
        this.add(201, LabelType.BATTERY_420_BWY);
        this.add(202, LabelType.BATTERY_450_BWY);
        this.add(203, LabelType.G1_0450_BWR_090);
        this.add(204, LabelType.G1_0370_BWR_090);
        this.add(209, LabelType.BATTERY_740);
        this.add(211, LabelType.BATTERY_740_RED);
        this.add(212, LabelType.BATTERY_600_RED);
        this.add(213, LabelType.BATTERY_600_BWY);
        this.add(214, LabelType.BATTERY_740_BWY);
        this.add(215, LabelType.BATTERY_600);
        this.add(217, LabelType.G1_0590_BWR_270);
        this.add(218, LabelType.G1_0970_BWR_090);
        this.add(219, LabelType.G1_0970_BWR_270);
        this.add(225, LabelType.BATTERY_1020);
        this.add(227, LabelType.BATTERY_1200);
        this.add(228, LabelType.BATTERY_1200_RED);
        this.add(229, LabelType.BATTERY_1200_BWY);
        this.add(241, LabelType.BATTERY_160_RED);
        this.add(242, LabelType.STAG_256);
        this.add(243, LabelType.BATTERY_160);
        this.add(244, LabelType.SES_GTAG_6);
        this.add(245, LabelType.BATTERY_160_BWY);
        this.add(246, LabelType.G1_0160_BW_090);
        this.add(247, LabelType.G1_0160_BWR_090);
        this.add(248, LabelType.G1_0160_BWY_090);
        this.add(249, LabelType.G1_0260_BW_090);
        this.add(250, LabelType.G1_0220_BW_090);
        this.add(251, LabelType.G1_0260_BW_270);
    }

    private void add(int typeId, LabelType labelType) {
        if (labelType == null) {
            throw new IllegalArgumentException("LabelType was null");
        }
        if (typeId < 0 || typeId > 255) {
            throw new IllegalArgumentException("Type identifier not within valid range");
        }
        LabelType assignedLabelType = (LabelType)this.labelTypeMapping.put(typeId, (Object)labelType);
        if (assignedLabelType != null) {
            throw new IllegalArgumentException(String.format("Type identifier %02X is already assigned to label type %s", typeId, assignedLabelType));
        }
    }

    public LabelType getTypeForLabelId(long labelId) {
        int code = (int)(labelId >> 24);
        LabelType labelType = (LabelType)this.labelTypeMapping.get(code);
        return labelType != null ? labelType : LabelType.UNKNOWN;
    }
}

