/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.accesspoint;

import at.mrdevelopment.esl.accesspoint.LabelStatusInfo;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.Ping;
import at.mrdevelopment.esl.wireless.RxMetrics;
import gnu.trove.map.hash.TLongObjectHashMap;
import org.joda.time.DateTime;

public class LabelStatusStorage {
    private final int accessPointId;
    private final TLongObjectHashMap<LabelStatusInfo> labelStatusInfos = new TLongObjectHashMap();

    public LabelStatusStorage(int accessPointId) {
        this.accessPointId = accessPointId;
    }

    public synchronized LabelStatusInfo getOrCreateLabelStatusInfo(Address labelAddress) {
        LabelStatusInfo labelStatusInfo = (LabelStatusInfo)this.labelStatusInfos.get(labelAddress.getHardwareAddress());
        if (labelStatusInfo == null) {
            labelStatusInfo = new LabelStatusInfo(labelAddress, this.accessPointId);
            this.labelStatusInfos.put(labelAddress.getHardwareAddress(), (Object)labelStatusInfo);
        }
        return labelStatusInfo;
    }

    public synchronized void pingRequestScheduled(Address labelAddress, DateTime pingRequestTime) {
        LabelStatusInfo labelStatusInfo = (LabelStatusInfo)this.labelStatusInfos.get(labelAddress.getHardwareAddress());
        LabelStatusInfo newLabelStatusInfo = labelStatusInfo.pingRequestScheduled(pingRequestTime);
        this.labelStatusInfos.put(labelAddress.getHardwareAddress(), (Object)newLabelStatusInfo);
    }

    public synchronized WakeupStatistic processPing(Address labelAddress, Ping ping, RxMetrics rxMetrics) {
        LabelStatusInfo labelStatusInfo = (LabelStatusInfo)this.labelStatusInfos.get(labelAddress.getHardwareAddress());
        LabelStatusInfo newLabelStatusInfo = labelStatusInfo.processPing(ping, rxMetrics);
        this.labelStatusInfos.put(labelAddress.getHardwareAddress(), (Object)newLabelStatusInfo);
        return newLabelStatusInfo.getWakeupStatistic();
    }

    public synchronized void joinRequested(Address labelAddress, DateTime joinRequestTime) {
        LabelStatusInfo labelStatusInfo = (LabelStatusInfo)this.labelStatusInfos.get(labelAddress.getHardwareAddress());
        LabelStatusInfo newLabelStatusInfo = labelStatusInfo.joinRequested(joinRequestTime);
        this.labelStatusInfos.put(labelAddress.getHardwareAddress(), (Object)newLabelStatusInfo);
    }

    public synchronized void joinCommitted(Address labelAddress, DateTime joinCommitTime) {
        LabelStatusInfo labelStatusInfo = (LabelStatusInfo)this.labelStatusInfos.get(labelAddress.getHardwareAddress());
        LabelStatusInfo newLabelStatusInfo = labelStatusInfo.joinCommitted(joinCommitTime);
        this.labelStatusInfos.put(labelAddress.getHardwareAddress(), (Object)newLabelStatusInfo);
    }

    public synchronized void joinFailed(Address labelAddress) {
        LabelStatusInfo labelStatusInfo = (LabelStatusInfo)this.labelStatusInfos.get(labelAddress.getHardwareAddress());
        LabelStatusInfo newLabelStatusInfo = labelStatusInfo.joinFailed();
        this.labelStatusInfos.put(labelAddress.getHardwareAddress(), (Object)newLabelStatusInfo);
    }

    public synchronized void eventReceived(Address labelAddress) {
        LabelStatusInfo labelStatusInfo = (LabelStatusInfo)this.labelStatusInfos.get(labelAddress.getHardwareAddress());
        LabelStatusInfo newLabelStatusInfo = labelStatusInfo.eventReceived();
        this.labelStatusInfos.put(labelAddress.getHardwareAddress(), (Object)newLabelStatusInfo);
    }

    public synchronized void eventCommitted(Address labelAddress) {
        LabelStatusInfo labelStatusInfo = (LabelStatusInfo)this.labelStatusInfos.get(labelAddress.getHardwareAddress());
        LabelStatusInfo newLabelStatusInfo = labelStatusInfo.eventCommitted();
        this.labelStatusInfos.put(labelAddress.getHardwareAddress(), (Object)newLabelStatusInfo);
    }

    public synchronized void eventFailed(Address labelAddress) {
        LabelStatusInfo labelStatusInfo = (LabelStatusInfo)this.labelStatusInfos.get(labelAddress.getHardwareAddress());
        LabelStatusInfo newLabelStatusInfo = labelStatusInfo.eventFailed();
        this.labelStatusInfos.put(labelAddress.getHardwareAddress(), (Object)newLabelStatusInfo);
    }

    public synchronized void setKeyScheduled(Address labelAddress) {
        LabelStatusInfo labelStatusInfo = (LabelStatusInfo)this.labelStatusInfos.get(labelAddress.getHardwareAddress());
        LabelStatusInfo newLabelStatusInfo = labelStatusInfo.setKeyScheduled();
        this.labelStatusInfos.put(labelAddress.getHardwareAddress(), (Object)newLabelStatusInfo);
    }

    public synchronized void setKeyCommitted(Address labelAddress, DateTime setKeyCommitTime) {
        LabelStatusInfo labelStatusInfo = (LabelStatusInfo)this.labelStatusInfos.get(labelAddress.getHardwareAddress());
        LabelStatusInfo newLabelStatusInfo = labelStatusInfo.setKeyCommitted(setKeyCommitTime);
        this.labelStatusInfos.put(labelAddress.getHardwareAddress(), (Object)newLabelStatusInfo);
    }

    public synchronized void setKeyFailed(Address labelAddress, DateTime setKeyFailTime) {
        LabelStatusInfo labelStatusInfo = (LabelStatusInfo)this.labelStatusInfos.get(labelAddress.getHardwareAddress());
        LabelStatusInfo newLabelStatusInfo = labelStatusInfo.setKeyFailed(setKeyFailTime);
        this.labelStatusInfos.put(labelAddress.getHardwareAddress(), (Object)newLabelStatusInfo);
    }

    public synchronized WakeupStatistic markKeyUnset(Address labelAddress, boolean keyUnset) {
        LabelStatusInfo labelStatusInfo = (LabelStatusInfo)this.labelStatusInfos.get(labelAddress.getHardwareAddress());
        LabelStatusInfo newLabelStatusInfo = labelStatusInfo.markKeyUnset(keyUnset);
        this.labelStatusInfos.put(labelAddress.getHardwareAddress(), (Object)newLabelStatusInfo);
        return newLabelStatusInfo.getWakeupStatistic();
    }

    public synchronized void pingFailed(Address labelAddress) {
        LabelStatusInfo labelStatusInfo = (LabelStatusInfo)this.labelStatusInfos.get(labelAddress.getHardwareAddress());
        LabelStatusInfo newLabelStatusInfo = labelStatusInfo.pingFailed();
        this.labelStatusInfos.put(labelAddress.getHardwareAddress(), (Object)newLabelStatusInfo);
    }
}

